/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponentList;
import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.FeeComponentList;
import com.amazon.spapi.model.finances.TaxWithheldComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An event related to a rental transaction.")
public class RentalTransactionEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="RentalEventType")
    private String rentalEventType = null;
    @SerializedName(value="ExtensionLength")
    private Integer extensionLength = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="RentalChargeList")
    private ChargeComponentList rentalChargeList = null;
    @SerializedName(value="RentalFeeList")
    private FeeComponentList rentalFeeList = null;
    @SerializedName(value="MarketplaceName")
    private String marketplaceName = null;
    @SerializedName(value="RentalInitialValue")
    private Currency rentalInitialValue = null;
    @SerializedName(value="RentalReimbursement")
    private Currency rentalReimbursement = null;
    @SerializedName(value="RentalTaxWithheldList")
    private TaxWithheldComponentList rentalTaxWithheldList = null;

    public RentalTransactionEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public RentalTransactionEvent rentalEventType(String rentalEventType) {
        this.rentalEventType = rentalEventType;
        return this;
    }

    @ApiModelProperty(value="The type of rental event.  Possible values:  * RentalCustomerPayment-Buyout - Transaction type that represents when the customer wants to buy out a rented item.  * RentalCustomerPayment-Extension - Transaction type that represents when the customer wants to extend the rental period.  * RentalCustomerRefund-Buyout - Transaction type that represents when the customer requests a refund for the buyout of the rented item.  * RentalCustomerRefund-Extension - Transaction type that represents when the customer requests a refund over the extension on the rented item.  * RentalHandlingFee - Transaction type that represents the fee that Amazon charges sellers who rent through Amazon.  * RentalChargeFailureReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a failed charge.  * RentalLostItemReimbursement - Transaction type that represents when Amazon sends money to the seller to compensate for a lost item.")
    public String getRentalEventType() {
        return this.rentalEventType;
    }

    public void setRentalEventType(String rentalEventType) {
        this.rentalEventType = rentalEventType;
    }

    public RentalTransactionEvent extensionLength(Integer extensionLength) {
        this.extensionLength = extensionLength;
        return this;
    }

    @ApiModelProperty(value="The number of days that the buyer extended an already rented item. This value is only returned for RentalCustomerPayment-Extension and RentalCustomerRefund-Extension events.")
    public Integer getExtensionLength() {
        return this.extensionLength;
    }

    public void setExtensionLength(Integer extensionLength) {
        this.extensionLength = extensionLength;
    }

    public RentalTransactionEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public RentalTransactionEvent rentalChargeList(ChargeComponentList rentalChargeList) {
        this.rentalChargeList = rentalChargeList;
        return this;
    }

    @ApiModelProperty(value="A list of charges associated with the rental event.")
    public ChargeComponentList getRentalChargeList() {
        return this.rentalChargeList;
    }

    public void setRentalChargeList(ChargeComponentList rentalChargeList) {
        this.rentalChargeList = rentalChargeList;
    }

    public RentalTransactionEvent rentalFeeList(FeeComponentList rentalFeeList) {
        this.rentalFeeList = rentalFeeList;
        return this;
    }

    @ApiModelProperty(value="A list of fees associated with the rental event.")
    public FeeComponentList getRentalFeeList() {
        return this.rentalFeeList;
    }

    public void setRentalFeeList(FeeComponentList rentalFeeList) {
        this.rentalFeeList = rentalFeeList;
    }

    public RentalTransactionEvent marketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
        return this;
    }

    @ApiModelProperty(value="The name of the marketplace.")
    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public RentalTransactionEvent rentalInitialValue(Currency rentalInitialValue) {
        this.rentalInitialValue = rentalInitialValue;
        return this;
    }

    @ApiModelProperty(value="The amount of money the customer originally paid to rent the item. This value is only returned for RentalChargeFailureReimbursement and RentalLostItemReimbursement events.")
    public Currency getRentalInitialValue() {
        return this.rentalInitialValue;
    }

    public void setRentalInitialValue(Currency rentalInitialValue) {
        this.rentalInitialValue = rentalInitialValue;
    }

    public RentalTransactionEvent rentalReimbursement(Currency rentalReimbursement) {
        this.rentalReimbursement = rentalReimbursement;
        return this;
    }

    @ApiModelProperty(value="The amount of money Amazon sends the seller to compensate for a lost item or a failed charge. This value is only returned for RentalChargeFailureReimbursement and RentalLostItemReimbursement events.")
    public Currency getRentalReimbursement() {
        return this.rentalReimbursement;
    }

    public void setRentalReimbursement(Currency rentalReimbursement) {
        this.rentalReimbursement = rentalReimbursement;
    }

    public RentalTransactionEvent rentalTaxWithheldList(TaxWithheldComponentList rentalTaxWithheldList) {
        this.rentalTaxWithheldList = rentalTaxWithheldList;
        return this;
    }

    @ApiModelProperty(value="A list of taxes withheld information for a rental item.")
    public TaxWithheldComponentList getRentalTaxWithheldList() {
        return this.rentalTaxWithheldList;
    }

    public void setRentalTaxWithheldList(TaxWithheldComponentList rentalTaxWithheldList) {
        this.rentalTaxWithheldList = rentalTaxWithheldList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RentalTransactionEvent rentalTransactionEvent = (RentalTransactionEvent)o;
        return Objects.equals(this.amazonOrderId, rentalTransactionEvent.amazonOrderId) && Objects.equals(this.rentalEventType, rentalTransactionEvent.rentalEventType) && Objects.equals(this.extensionLength, rentalTransactionEvent.extensionLength) && Objects.equals(this.postedDate, rentalTransactionEvent.postedDate) && Objects.equals(this.rentalChargeList, rentalTransactionEvent.rentalChargeList) && Objects.equals(this.rentalFeeList, rentalTransactionEvent.rentalFeeList) && Objects.equals(this.marketplaceName, rentalTransactionEvent.marketplaceName) && Objects.equals(this.rentalInitialValue, rentalTransactionEvent.rentalInitialValue) && Objects.equals(this.rentalReimbursement, rentalTransactionEvent.rentalReimbursement) && Objects.equals(this.rentalTaxWithheldList, rentalTransactionEvent.rentalTaxWithheldList);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.rentalEventType, this.extensionLength, this.postedDate, this.rentalChargeList, this.rentalFeeList, this.marketplaceName, this.rentalInitialValue, this.rentalReimbursement, this.rentalTaxWithheldList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RentalTransactionEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    rentalEventType: ").append(this.toIndentedString(this.rentalEventType)).append("\n");
        sb.append("    extensionLength: ").append(this.toIndentedString(this.extensionLength)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    rentalChargeList: ").append(this.toIndentedString(this.rentalChargeList)).append("\n");
        sb.append("    rentalFeeList: ").append(this.toIndentedString(this.rentalFeeList)).append("\n");
        sb.append("    marketplaceName: ").append(this.toIndentedString(this.marketplaceName)).append("\n");
        sb.append("    rentalInitialValue: ").append(this.toIndentedString(this.rentalInitialValue)).append("\n");
        sb.append("    rentalReimbursement: ").append(this.toIndentedString(this.rentalReimbursement)).append("\n");
        sb.append("    rentalTaxWithheldList: ").append(this.toIndentedString(this.rentalTaxWithheldList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

