/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A fee associated with the event.")
public class FeeComponent {
    @SerializedName(value="FeeType")
    private String feeType = null;
    @SerializedName(value="FeeAmount")
    private Currency feeAmount = null;

    public FeeComponent feeType(String feeType) {
        this.feeType = feeType;
        return this;
    }

    @ApiModelProperty(value="The type of fee. For more information about Selling on Amazon fees, see [Selling on Amazon Fee Schedule](https://sellercentral.amazon.com/gp/help/200336920) on Seller Central. For more information about Fulfillment by Amazon fees, see [FBA features, services and fees](https://sellercentral.amazon.com/gp/help/201074400) on Seller Central.")
    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public FeeComponent feeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the fee.")
    public Currency getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeeComponent feeComponent = (FeeComponent)o;
        return Objects.equals(this.feeType, feeComponent.feeType) && Objects.equals(this.feeAmount, feeComponent.feeAmount);
    }

    public int hashCode() {
        return Objects.hash(this.feeType, this.feeAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeeComponent {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

