/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An item of a debt payment or debt adjustment.")
public class DebtRecoveryItem {
    @SerializedName(value="RecoveryAmount")
    private Currency recoveryAmount = null;
    @SerializedName(value="OriginalAmount")
    private Currency originalAmount = null;
    @SerializedName(value="GroupBeginDate")
    private String groupBeginDate = null;
    @SerializedName(value="GroupEndDate")
    private String groupEndDate = null;

    public DebtRecoveryItem recoveryAmount(Currency recoveryAmount) {
        this.recoveryAmount = recoveryAmount;
        return this;
    }

    @ApiModelProperty(value="The amount applied for the recovery item.")
    public Currency getRecoveryAmount() {
        return this.recoveryAmount;
    }

    public void setRecoveryAmount(Currency recoveryAmount) {
        this.recoveryAmount = recoveryAmount;
    }

    public DebtRecoveryItem originalAmount(Currency originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    @ApiModelProperty(value="The original debt amount.")
    public Currency getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(Currency originalAmount) {
        this.originalAmount = originalAmount;
    }

    public DebtRecoveryItem groupBeginDate(String groupBeginDate) {
        this.groupBeginDate = groupBeginDate;
        return this;
    }

    @ApiModelProperty(value="The beginning date and time of the financial event group that contains the debt. In ISO 8601 date time format.")
    public String getGroupBeginDate() {
        return this.groupBeginDate;
    }

    public void setGroupBeginDate(String groupBeginDate) {
        this.groupBeginDate = groupBeginDate;
    }

    public DebtRecoveryItem groupEndDate(String groupEndDate) {
        this.groupEndDate = groupEndDate;
        return this;
    }

    @ApiModelProperty(value="The ending date and time of the financial event group that contains the debt. In ISO 8601 date time format.")
    public String getGroupEndDate() {
        return this.groupEndDate;
    }

    public void setGroupEndDate(String groupEndDate) {
        this.groupEndDate = groupEndDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebtRecoveryItem debtRecoveryItem = (DebtRecoveryItem)o;
        return Objects.equals(this.recoveryAmount, debtRecoveryItem.recoveryAmount) && Objects.equals(this.originalAmount, debtRecoveryItem.originalAmount) && Objects.equals(this.groupBeginDate, debtRecoveryItem.groupBeginDate) && Objects.equals(this.groupEndDate, debtRecoveryItem.groupEndDate);
    }

    public int hashCode() {
        return Objects.hash(this.recoveryAmount, this.originalAmount, this.groupBeginDate, this.groupEndDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DebtRecoveryItem {\n");
        sb.append("    recoveryAmount: ").append(this.toIndentedString(this.recoveryAmount)).append("\n");
        sb.append("    originalAmount: ").append(this.toIndentedString(this.originalAmount)).append("\n");
        sb.append("    groupBeginDate: ").append(this.toIndentedString(this.groupBeginDate)).append("\n");
        sb.append("    groupEndDate: ").append(this.toIndentedString(this.groupEndDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

