/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeInstrumentList;
import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.DebtRecoveryItemList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A debt payment or debt adjustment.")
public class DebtRecoveryEvent {
    @SerializedName(value="DebtRecoveryType")
    private String debtRecoveryType = null;
    @SerializedName(value="RecoveryAmount")
    private Currency recoveryAmount = null;
    @SerializedName(value="OverPaymentCredit")
    private Currency overPaymentCredit = null;
    @SerializedName(value="DebtRecoveryItemList")
    private DebtRecoveryItemList debtRecoveryItemList = null;
    @SerializedName(value="ChargeInstrumentList")
    private ChargeInstrumentList chargeInstrumentList = null;

    public DebtRecoveryEvent debtRecoveryType(String debtRecoveryType) {
        this.debtRecoveryType = debtRecoveryType;
        return this;
    }

    @ApiModelProperty(value="The debt recovery type.  Possible values:  * DebtPayment  * DebtPaymentFailure  *DebtAdjustment")
    public String getDebtRecoveryType() {
        return this.debtRecoveryType;
    }

    public void setDebtRecoveryType(String debtRecoveryType) {
        this.debtRecoveryType = debtRecoveryType;
    }

    public DebtRecoveryEvent recoveryAmount(Currency recoveryAmount) {
        this.recoveryAmount = recoveryAmount;
        return this;
    }

    @ApiModelProperty(value="The amount applied for recovery.")
    public Currency getRecoveryAmount() {
        return this.recoveryAmount;
    }

    public void setRecoveryAmount(Currency recoveryAmount) {
        this.recoveryAmount = recoveryAmount;
    }

    public DebtRecoveryEvent overPaymentCredit(Currency overPaymentCredit) {
        this.overPaymentCredit = overPaymentCredit;
        return this;
    }

    @ApiModelProperty(value="The amount returned for overpayment.")
    public Currency getOverPaymentCredit() {
        return this.overPaymentCredit;
    }

    public void setOverPaymentCredit(Currency overPaymentCredit) {
        this.overPaymentCredit = overPaymentCredit;
    }

    public DebtRecoveryEvent debtRecoveryItemList(DebtRecoveryItemList debtRecoveryItemList) {
        this.debtRecoveryItemList = debtRecoveryItemList;
        return this;
    }

    @ApiModelProperty(value="")
    public DebtRecoveryItemList getDebtRecoveryItemList() {
        return this.debtRecoveryItemList;
    }

    public void setDebtRecoveryItemList(DebtRecoveryItemList debtRecoveryItemList) {
        this.debtRecoveryItemList = debtRecoveryItemList;
    }

    public DebtRecoveryEvent chargeInstrumentList(ChargeInstrumentList chargeInstrumentList) {
        this.chargeInstrumentList = chargeInstrumentList;
        return this;
    }

    @ApiModelProperty(value="")
    public ChargeInstrumentList getChargeInstrumentList() {
        return this.chargeInstrumentList;
    }

    public void setChargeInstrumentList(ChargeInstrumentList chargeInstrumentList) {
        this.chargeInstrumentList = chargeInstrumentList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebtRecoveryEvent debtRecoveryEvent = (DebtRecoveryEvent)o;
        return Objects.equals(this.debtRecoveryType, debtRecoveryEvent.debtRecoveryType) && Objects.equals(this.recoveryAmount, debtRecoveryEvent.recoveryAmount) && Objects.equals(this.overPaymentCredit, debtRecoveryEvent.overPaymentCredit) && Objects.equals(this.debtRecoveryItemList, debtRecoveryEvent.debtRecoveryItemList) && Objects.equals(this.chargeInstrumentList, debtRecoveryEvent.chargeInstrumentList);
    }

    public int hashCode() {
        return Objects.hash(this.debtRecoveryType, this.recoveryAmount, this.overPaymentCredit, this.debtRecoveryItemList, this.chargeInstrumentList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DebtRecoveryEvent {\n");
        sb.append("    debtRecoveryType: ").append(this.toIndentedString(this.debtRecoveryType)).append("\n");
        sb.append("    recoveryAmount: ").append(this.toIndentedString(this.recoveryAmount)).append("\n");
        sb.append("    overPaymentCredit: ").append(this.toIndentedString(this.overPaymentCredit)).append("\n");
        sb.append("    debtRecoveryItemList: ").append(this.toIndentedString(this.debtRecoveryItemList)).append("\n");
        sb.append("    chargeInstrumentList: ").append(this.toIndentedString(this.chargeInstrumentList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

