/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponent;
import com.amazon.spapi.model.finances.Currency;
import com.amazon.spapi.model.finances.FeeComponent;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An event related to coupon payments.")
public class CouponPaymentEvent {
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="CouponId")
    private String couponId = null;
    @SerializedName(value="SellerCouponDescription")
    private String sellerCouponDescription = null;
    @SerializedName(value="ClipOrRedemptionCount")
    private Long clipOrRedemptionCount = null;
    @SerializedName(value="PaymentEventId")
    private String paymentEventId = null;
    @SerializedName(value="FeeComponent")
    private FeeComponent feeComponent = null;
    @SerializedName(value="ChargeComponent")
    private ChargeComponent chargeComponent = null;
    @SerializedName(value="TotalAmount")
    private Currency totalAmount = null;

    public CouponPaymentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public CouponPaymentEvent couponId(String couponId) {
        this.couponId = couponId;
        return this;
    }

    @ApiModelProperty(value="A coupon identifier.")
    public String getCouponId() {
        return this.couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public CouponPaymentEvent sellerCouponDescription(String sellerCouponDescription) {
        this.sellerCouponDescription = sellerCouponDescription;
        return this;
    }

    @ApiModelProperty(value="The description provided by the seller when they created the coupon.")
    public String getSellerCouponDescription() {
        return this.sellerCouponDescription;
    }

    public void setSellerCouponDescription(String sellerCouponDescription) {
        this.sellerCouponDescription = sellerCouponDescription;
    }

    public CouponPaymentEvent clipOrRedemptionCount(Long clipOrRedemptionCount) {
        this.clipOrRedemptionCount = clipOrRedemptionCount;
        return this;
    }

    @ApiModelProperty(value="The number of coupon clips or redemptions.")
    public Long getClipOrRedemptionCount() {
        return this.clipOrRedemptionCount;
    }

    public void setClipOrRedemptionCount(Long clipOrRedemptionCount) {
        this.clipOrRedemptionCount = clipOrRedemptionCount;
    }

    public CouponPaymentEvent paymentEventId(String paymentEventId) {
        this.paymentEventId = paymentEventId;
        return this;
    }

    @ApiModelProperty(value="A payment event identifier.")
    public String getPaymentEventId() {
        return this.paymentEventId;
    }

    public void setPaymentEventId(String paymentEventId) {
        this.paymentEventId = paymentEventId;
    }

    public CouponPaymentEvent feeComponent(FeeComponent feeComponent) {
        this.feeComponent = feeComponent;
        return this;
    }

    @ApiModelProperty(value="")
    public FeeComponent getFeeComponent() {
        return this.feeComponent;
    }

    public void setFeeComponent(FeeComponent feeComponent) {
        this.feeComponent = feeComponent;
    }

    public CouponPaymentEvent chargeComponent(ChargeComponent chargeComponent) {
        this.chargeComponent = chargeComponent;
        return this;
    }

    @ApiModelProperty(value="")
    public ChargeComponent getChargeComponent() {
        return this.chargeComponent;
    }

    public void setChargeComponent(ChargeComponent chargeComponent) {
        this.chargeComponent = chargeComponent;
    }

    public CouponPaymentEvent totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="The FeeComponent value plus the ChargeComponent value.")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouponPaymentEvent couponPaymentEvent = (CouponPaymentEvent)o;
        return Objects.equals(this.postedDate, couponPaymentEvent.postedDate) && Objects.equals(this.couponId, couponPaymentEvent.couponId) && Objects.equals(this.sellerCouponDescription, couponPaymentEvent.sellerCouponDescription) && Objects.equals(this.clipOrRedemptionCount, couponPaymentEvent.clipOrRedemptionCount) && Objects.equals(this.paymentEventId, couponPaymentEvent.paymentEventId) && Objects.equals(this.feeComponent, couponPaymentEvent.feeComponent) && Objects.equals(this.chargeComponent, couponPaymentEvent.chargeComponent) && Objects.equals(this.totalAmount, couponPaymentEvent.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.couponId, this.sellerCouponDescription, this.clipOrRedemptionCount, this.paymentEventId, this.feeComponent, this.chargeComponent, this.totalAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CouponPaymentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    couponId: ").append(this.toIndentedString(this.couponId)).append("\n");
        sb.append("    sellerCouponDescription: ").append(this.toIndentedString(this.sellerCouponDescription)).append("\n");
        sb.append("    clipOrRedemptionCount: ").append(this.toIndentedString(this.clipOrRedemptionCount)).append("\n");
        sb.append("    paymentEventId: ").append(this.toIndentedString(this.paymentEventId)).append("\n");
        sb.append("    feeComponent: ").append(this.toIndentedString(this.feeComponent)).append("\n");
        sb.append("    chargeComponent: ").append(this.toIndentedString(this.chargeComponent)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

