/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.feeds;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Information required for the feed document.")
public class FeedDocument {
    @SerializedName(value="feedDocumentId")
    private String feedDocumentId = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="compressionAlgorithm")
    private CompressionAlgorithmEnum compressionAlgorithm = null;

    public FeedDocument feedDocumentId(String feedDocumentId) {
        this.feedDocumentId = feedDocumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the feed document. This identifier is unique only in combination with a seller ID.")
    public String getFeedDocumentId() {
        return this.feedDocumentId;
    }

    public void setFeedDocumentId(String feedDocumentId) {
        this.feedDocumentId = feedDocumentId;
    }

    public FeedDocument url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="A presigned URL for the feed document. This URL expires after 5 minutes.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FeedDocument compressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
        return this;
    }

    @ApiModelProperty(value="If present, the feed document contents are compressed using the indicated algorithm.")
    public CompressionAlgorithmEnum getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedDocument feedDocument = (FeedDocument)o;
        return Objects.equals(this.feedDocumentId, feedDocument.feedDocumentId) && Objects.equals(this.url, feedDocument.url) && Objects.equals((Object)this.compressionAlgorithm, (Object)feedDocument.compressionAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feedDocumentId, this.url, this.compressionAlgorithm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeedDocument {\n");
        sb.append("    feedDocumentId: ").append(this.toIndentedString(this.feedDocumentId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    compressionAlgorithm: ").append(this.toIndentedString((Object)this.compressionAlgorithm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionAlgorithmEnum {
        GZIP("GZIP");

        private String value;

        private CompressionAlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionAlgorithmEnum fromValue(String text) {
            for (CompressionAlgorithmEnum b : CompressionAlgorithmEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionAlgorithmEnum> {
            public void write(JsonWriter jsonWriter, CompressionAlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CompressionAlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionAlgorithmEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

