/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fbasmallandlight;

import com.amazon.spapi.model.ErrorList;
import com.amazon.spapi.model.fbasmallandlight.FeeLineItem;
import com.amazon.spapi.model.fbasmallandlight.MoneyType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The fee estimate for a specific item.")
public class FeePreview {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="price")
    private MoneyType price = null;
    @SerializedName(value="feeBreakdown")
    private List<FeeLineItem> feeBreakdown = null;
    @SerializedName(value="totalFees")
    private MoneyType totalFees = null;
    @SerializedName(value="errors")
    private ErrorList errors = null;

    public FeePreview asin(String asin) {
        this.asin = asin;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) value used to identify the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public FeePreview price(MoneyType price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(value="The price that the seller plans to charge for the item.")
    public MoneyType getPrice() {
        return this.price;
    }

    public void setPrice(MoneyType price) {
        this.price = price;
    }

    public FeePreview feeBreakdown(List<FeeLineItem> feeBreakdown) {
        this.feeBreakdown = feeBreakdown;
        return this;
    }

    public FeePreview addFeeBreakdownItem(FeeLineItem feeBreakdownItem) {
        if (this.feeBreakdown == null) {
            this.feeBreakdown = new ArrayList<FeeLineItem>();
        }
        this.feeBreakdown.add(feeBreakdownItem);
        return this;
    }

    @ApiModelProperty(value="A list of the Small and Light fees for the item.")
    public List<FeeLineItem> getFeeBreakdown() {
        return this.feeBreakdown;
    }

    public void setFeeBreakdown(List<FeeLineItem> feeBreakdown) {
        this.feeBreakdown = feeBreakdown;
    }

    public FeePreview totalFees(MoneyType totalFees) {
        this.totalFees = totalFees;
        return this;
    }

    @ApiModelProperty(value="The total fees charged if the item participated in the Small and Light program.")
    public MoneyType getTotalFees() {
        return this.totalFees;
    }

    public void setTotalFees(MoneyType totalFees) {
        this.totalFees = totalFees;
    }

    public FeePreview errors(ErrorList errors) {
        this.errors = errors;
        return this;
    }

    @ApiModelProperty(value="One or more unexpected errors occurred during the getSmallAndLightFeePreview operation.")
    public ErrorList getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorList errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeePreview feePreview = (FeePreview)o;
        return Objects.equals(this.asin, feePreview.asin) && Objects.equals(this.price, feePreview.price) && Objects.equals(this.feeBreakdown, feePreview.feeBreakdown) && Objects.equals(this.totalFees, feePreview.totalFees) && Objects.equals(this.errors, feePreview.errors);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.price, this.feeBreakdown, this.totalFees, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeePreview {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    feeBreakdown: ").append(this.toIndentedString(this.feeBreakdown)).append("\n");
        sb.append("    totalFees: ").append(this.toIndentedString(this.totalFees)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

