/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fbainventory;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="The misplaced or warehouse damaged inventory that is actively being confirmed at our fulfillment centers.")
public class ResearchingQuantityEntry {
    @SerializedName(value="name")
    private NameEnum name = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;

    public ResearchingQuantityEntry name(NameEnum name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The duration of the research.")
    public NameEnum getName() {
        return this.name;
    }

    public void setName(NameEnum name) {
        this.name = name;
    }

    public ResearchingQuantityEntry quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of units.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResearchingQuantityEntry researchingQuantityEntry = (ResearchingQuantityEntry)o;
        return Objects.equals((Object)this.name, (Object)researchingQuantityEntry.name) && Objects.equals(this.quantity, researchingQuantityEntry.quantity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.quantity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResearchingQuantityEntry {\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NameEnum {
        RESEARCHINGQUANTITYINSHORTTERM("researchingQuantityInShortTerm"),
        RESEARCHINGQUANTITYINMIDTERM("researchingQuantityInMidTerm"),
        RESEARCHINGQUANTITYINLONGTERM("researchingQuantityInLongTerm");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NameEnum fromValue(String text) {
            for (NameEnum b : NameEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NameEnum> {
            public void write(JsonWriter jsonWriter, NameEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NameEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

