/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fbainventory;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Describes a granularity at which inventory data can be aggregated. For example, if you use Marketplace granularity, the fulfillable quantity will reflect inventory that could be fulfilled in the given marketplace.")
public class Granularity {
    @SerializedName(value="granularityType")
    private GranularityTypeEnum granularityType = null;
    @SerializedName(value="granularityId")
    private String granularityId = null;

    public Granularity granularityType(GranularityTypeEnum granularityType) {
        this.granularityType = granularityType;
        return this;
    }

    @ApiModelProperty(value="The granularity type for the inventory aggregation level.")
    public GranularityTypeEnum getGranularityType() {
        return this.granularityType;
    }

    public void setGranularityType(GranularityTypeEnum granularityType) {
        this.granularityType = granularityType;
    }

    public Granularity granularityId(String granularityId) {
        this.granularityId = granularityId;
        return this;
    }

    @ApiModelProperty(value="The granularity ID for the specified granularity type. When granularityType is Marketplace, specify the marketplaceId.")
    public String getGranularityId() {
        return this.granularityId;
    }

    public void setGranularityId(String granularityId) {
        this.granularityId = granularityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Granularity granularity = (Granularity)o;
        return Objects.equals((Object)this.granularityType, (Object)granularity.granularityType) && Objects.equals(this.granularityId, granularity.granularityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.granularityType, this.granularityId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Granularity {\n");
        sb.append("    granularityType: ").append(this.toIndentedString((Object)this.granularityType)).append("\n");
        sb.append("    granularityId: ").append(this.toIndentedString(this.granularityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GranularityTypeEnum {
        MARKETPLACE("Marketplace");

        private String value;

        private GranularityTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GranularityTypeEnum fromValue(String text) {
            for (GranularityTypeEnum b : GranularityTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<GranularityTypeEnum> {
            public void write(JsonWriter jsonWriter, GranularityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GranularityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GranularityTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

