/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fbainboundeligibility;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The response object which contains the ASIN, marketplaceId if required, eligibility program, the eligibility status (boolean), and a list of ineligibility reason codes.")
public class ItemEligibilityPreview {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="program")
    private ProgramEnum program = null;
    @SerializedName(value="isEligibleForProgram")
    private Boolean isEligibleForProgram = null;
    @SerializedName(value="ineligibilityReasonList")
    private List<IneligibilityReasonListEnum> ineligibilityReasonList = null;

    public ItemEligibilityPreview asin(String asin) {
        this.asin = asin;
        return this;
    }

    @ApiModelProperty(required=true, value="The ASIN for which eligibility was determined.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ItemEligibilityPreview marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="The marketplace for which eligibility was determined.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemEligibilityPreview program(ProgramEnum program) {
        this.program = program;
        return this;
    }

    @ApiModelProperty(required=true, value="The program for which eligibility was determined.")
    public ProgramEnum getProgram() {
        return this.program;
    }

    public void setProgram(ProgramEnum program) {
        this.program = program;
    }

    public ItemEligibilityPreview isEligibleForProgram(Boolean isEligibleForProgram) {
        this.isEligibleForProgram = isEligibleForProgram;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the item is eligible for the program.")
    public Boolean isIsEligibleForProgram() {
        return this.isEligibleForProgram;
    }

    public void setIsEligibleForProgram(Boolean isEligibleForProgram) {
        this.isEligibleForProgram = isEligibleForProgram;
    }

    public ItemEligibilityPreview ineligibilityReasonList(List<IneligibilityReasonListEnum> ineligibilityReasonList) {
        this.ineligibilityReasonList = ineligibilityReasonList;
        return this;
    }

    public ItemEligibilityPreview addIneligibilityReasonListItem(IneligibilityReasonListEnum ineligibilityReasonListItem) {
        if (this.ineligibilityReasonList == null) {
            this.ineligibilityReasonList = new ArrayList<IneligibilityReasonListEnum>();
        }
        this.ineligibilityReasonList.add(ineligibilityReasonListItem);
        return this;
    }

    @ApiModelProperty(value="Potential Ineligibility Reason Codes.")
    public List<IneligibilityReasonListEnum> getIneligibilityReasonList() {
        return this.ineligibilityReasonList;
    }

    public void setIneligibilityReasonList(List<IneligibilityReasonListEnum> ineligibilityReasonList) {
        this.ineligibilityReasonList = ineligibilityReasonList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemEligibilityPreview itemEligibilityPreview = (ItemEligibilityPreview)o;
        return Objects.equals(this.asin, itemEligibilityPreview.asin) && Objects.equals(this.marketplaceId, itemEligibilityPreview.marketplaceId) && Objects.equals((Object)this.program, (Object)itemEligibilityPreview.program) && Objects.equals(this.isEligibleForProgram, itemEligibilityPreview.isEligibleForProgram) && Objects.equals(this.ineligibilityReasonList, itemEligibilityPreview.ineligibilityReasonList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asin, this.marketplaceId, this.program, this.isEligibleForProgram, this.ineligibilityReasonList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemEligibilityPreview {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    program: ").append(this.toIndentedString((Object)this.program)).append("\n");
        sb.append("    isEligibleForProgram: ").append(this.toIndentedString(this.isEligibleForProgram)).append("\n");
        sb.append("    ineligibilityReasonList: ").append(this.toIndentedString(this.ineligibilityReasonList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IneligibilityReasonListEnum {
        FBA_INB_0004("FBA_INB_0004"),
        FBA_INB_0006("FBA_INB_0006"),
        FBA_INB_0007("FBA_INB_0007"),
        FBA_INB_0008("FBA_INB_0008"),
        FBA_INB_0009("FBA_INB_0009"),
        FBA_INB_0010("FBA_INB_0010"),
        FBA_INB_0011("FBA_INB_0011"),
        FBA_INB_0012("FBA_INB_0012"),
        FBA_INB_0013("FBA_INB_0013"),
        FBA_INB_0014("FBA_INB_0014"),
        FBA_INB_0015("FBA_INB_0015"),
        FBA_INB_0016("FBA_INB_0016"),
        FBA_INB_0017("FBA_INB_0017"),
        FBA_INB_0018("FBA_INB_0018"),
        FBA_INB_0019("FBA_INB_0019"),
        FBA_INB_0034("FBA_INB_0034"),
        FBA_INB_0035("FBA_INB_0035"),
        FBA_INB_0036("FBA_INB_0036"),
        FBA_INB_0037("FBA_INB_0037"),
        FBA_INB_0038("FBA_INB_0038"),
        FBA_INB_0050("FBA_INB_0050"),
        FBA_INB_0051("FBA_INB_0051"),
        FBA_INB_0053("FBA_INB_0053"),
        FBA_INB_0055("FBA_INB_0055"),
        FBA_INB_0056("FBA_INB_0056"),
        FBA_INB_0059("FBA_INB_0059"),
        FBA_INB_0065("FBA_INB_0065"),
        FBA_INB_0066("FBA_INB_0066"),
        FBA_INB_0067("FBA_INB_0067"),
        FBA_INB_0068("FBA_INB_0068"),
        FBA_INB_0095("FBA_INB_0095"),
        FBA_INB_0097("FBA_INB_0097"),
        FBA_INB_0098("FBA_INB_0098"),
        FBA_INB_0099("FBA_INB_0099"),
        FBA_INB_0100("FBA_INB_0100"),
        FBA_INB_0103("FBA_INB_0103"),
        FBA_INB_0104("FBA_INB_0104"),
        UNKNOWN_INB_ERROR_CODE("UNKNOWN_INB_ERROR_CODE");

        private String value;

        private IneligibilityReasonListEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IneligibilityReasonListEnum fromValue(String text) {
            for (IneligibilityReasonListEnum b : IneligibilityReasonListEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IneligibilityReasonListEnum> {
            public void write(JsonWriter jsonWriter, IneligibilityReasonListEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IneligibilityReasonListEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IneligibilityReasonListEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProgramEnum {
        INBOUND("INBOUND"),
        COMMINGLING("COMMINGLING");

        private String value;

        private ProgramEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProgramEnum fromValue(String text) {
            for (ProgramEnum b : ProgramEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProgramEnum> {
            public void write(JsonWriter jsonWriter, ProgramEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProgramEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProgramEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

