/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.easyship;

import com.amazon.spapi.model.easyship.HandoverMethod;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A time window to hand over an Easy Ship package to Amazon Logistics.")
public class TimeSlot {
    @SerializedName(value="slotId")
    private String slotId = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="handoverMethod")
    private HandoverMethod handoverMethod = null;

    public TimeSlot slotId(String slotId) {
        this.slotId = slotId;
        return this;
    }

    @ApiModelProperty(required=true, value="An Amazon-defined identifier for a time slot.")
    public String getSlotId() {
        return this.slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public TimeSlot startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start date and time of the time slot.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public TimeSlot endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end date and time of the time slot.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public TimeSlot handoverMethod(HandoverMethod handoverMethod) {
        this.handoverMethod = handoverMethod;
        return this;
    }

    @ApiModelProperty(value="The method by which a seller will hand a package over to Amazon Logistics.")
    public HandoverMethod getHandoverMethod() {
        return this.handoverMethod;
    }

    public void setHandoverMethod(HandoverMethod handoverMethod) {
        this.handoverMethod = handoverMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSlot timeSlot = (TimeSlot)o;
        return Objects.equals(this.slotId, timeSlot.slotId) && Objects.equals(this.startTime, timeSlot.startTime) && Objects.equals(this.endTime, timeSlot.endTime) && Objects.equals((Object)this.handoverMethod, (Object)timeSlot.handoverMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slotId, this.startTime, this.endTime, this.handoverMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeSlot {\n");
        sb.append("    slotId: ").append(this.toIndentedString(this.slotId)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    handoverMethod: ").append(this.toIndentedString((Object)this.handoverMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

