/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="When a request produces a response that exceeds the `pageSize`, pagination occurs. This means the response is divided into individual pages. To retrieve the next page or the previous page, you must pass the `nextToken` value or the `previousToken` value as the `pageToken` parameter in the next request. When you receive the last page, there will be no `nextToken` key in the pagination object.")
public class Pagination {
    @SerializedName(value="nextToken")
    private String nextToken = null;
    @SerializedName(value="previousToken")
    private String previousToken = null;

    public Pagination nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @ApiModelProperty(value="A token that can be used to fetch the next page.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public Pagination previousToken(String previousToken) {
        this.previousToken = previousToken;
        return this;
    }

    @ApiModelProperty(value="A token that can be used to fetch the previous page.")
    public String getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(String previousToken) {
        this.previousToken = previousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.nextToken, pagination.nextToken) && Objects.equals(this.previousToken, pagination.previousToken);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken, this.previousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    previousToken: ").append(this.toIndentedString(this.previousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

