/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.amazon.spapi.model.catalogitems.ItemVendorDetailsCategory;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Vendor details associated with an Amazon catalog item for the indicated Amazon marketplace.")
public class ItemVendorDetailsByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="brandCode")
    private String brandCode = null;
    @SerializedName(value="manufacturerCode")
    private String manufacturerCode = null;
    @SerializedName(value="manufacturerCodeParent")
    private String manufacturerCodeParent = null;
    @SerializedName(value="productCategory")
    private ItemVendorDetailsCategory productCategory = null;
    @SerializedName(value="productGroup")
    private String productGroup = null;
    @SerializedName(value="productSubcategory")
    private ItemVendorDetailsCategory productSubcategory = null;
    @SerializedName(value="replenishmentCategory")
    private ReplenishmentCategoryEnum replenishmentCategory = null;

    public ItemVendorDetailsByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemVendorDetailsByMarketplace brandCode(String brandCode) {
        this.brandCode = brandCode;
        return this;
    }

    @ApiModelProperty(value="Brand code associated with an Amazon catalog item.")
    public String getBrandCode() {
        return this.brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public ItemVendorDetailsByMarketplace manufacturerCode(String manufacturerCode) {
        this.manufacturerCode = manufacturerCode;
        return this;
    }

    @ApiModelProperty(value="Manufacturer code associated with an Amazon catalog item.")
    public String getManufacturerCode() {
        return this.manufacturerCode;
    }

    public void setManufacturerCode(String manufacturerCode) {
        this.manufacturerCode = manufacturerCode;
    }

    public ItemVendorDetailsByMarketplace manufacturerCodeParent(String manufacturerCodeParent) {
        this.manufacturerCodeParent = manufacturerCodeParent;
        return this;
    }

    @ApiModelProperty(value="Parent vendor code of the manufacturer code.")
    public String getManufacturerCodeParent() {
        return this.manufacturerCodeParent;
    }

    public void setManufacturerCodeParent(String manufacturerCodeParent) {
        this.manufacturerCodeParent = manufacturerCodeParent;
    }

    public ItemVendorDetailsByMarketplace productCategory(ItemVendorDetailsCategory productCategory) {
        this.productCategory = productCategory;
        return this;
    }

    @ApiModelProperty(value="Product category associated with an Amazon catalog item.")
    public ItemVendorDetailsCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ItemVendorDetailsCategory productCategory) {
        this.productCategory = productCategory;
    }

    public ItemVendorDetailsByMarketplace productGroup(String productGroup) {
        this.productGroup = productGroup;
        return this;
    }

    @ApiModelProperty(value="Product group associated with an Amazon catalog item.")
    public String getProductGroup() {
        return this.productGroup;
    }

    public void setProductGroup(String productGroup) {
        this.productGroup = productGroup;
    }

    public ItemVendorDetailsByMarketplace productSubcategory(ItemVendorDetailsCategory productSubcategory) {
        this.productSubcategory = productSubcategory;
        return this;
    }

    @ApiModelProperty(value="Product subcategory associated with an Amazon catalog item.")
    public ItemVendorDetailsCategory getProductSubcategory() {
        return this.productSubcategory;
    }

    public void setProductSubcategory(ItemVendorDetailsCategory productSubcategory) {
        this.productSubcategory = productSubcategory;
    }

    public ItemVendorDetailsByMarketplace replenishmentCategory(ReplenishmentCategoryEnum replenishmentCategory) {
        this.replenishmentCategory = replenishmentCategory;
        return this;
    }

    @ApiModelProperty(value="Replenishment category associated with an Amazon catalog item.")
    public ReplenishmentCategoryEnum getReplenishmentCategory() {
        return this.replenishmentCategory;
    }

    public void setReplenishmentCategory(ReplenishmentCategoryEnum replenishmentCategory) {
        this.replenishmentCategory = replenishmentCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVendorDetailsByMarketplace itemVendorDetailsByMarketplace = (ItemVendorDetailsByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemVendorDetailsByMarketplace.marketplaceId) && Objects.equals(this.brandCode, itemVendorDetailsByMarketplace.brandCode) && Objects.equals(this.manufacturerCode, itemVendorDetailsByMarketplace.manufacturerCode) && Objects.equals(this.manufacturerCodeParent, itemVendorDetailsByMarketplace.manufacturerCodeParent) && Objects.equals(this.productCategory, itemVendorDetailsByMarketplace.productCategory) && Objects.equals(this.productGroup, itemVendorDetailsByMarketplace.productGroup) && Objects.equals(this.productSubcategory, itemVendorDetailsByMarketplace.productSubcategory) && Objects.equals((Object)this.replenishmentCategory, (Object)itemVendorDetailsByMarketplace.replenishmentCategory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.brandCode, this.manufacturerCode, this.manufacturerCodeParent, this.productCategory, this.productGroup, this.productSubcategory, this.replenishmentCategory});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemVendorDetailsByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    brandCode: ").append(this.toIndentedString(this.brandCode)).append("\n");
        sb.append("    manufacturerCode: ").append(this.toIndentedString(this.manufacturerCode)).append("\n");
        sb.append("    manufacturerCodeParent: ").append(this.toIndentedString(this.manufacturerCodeParent)).append("\n");
        sb.append("    productCategory: ").append(this.toIndentedString(this.productCategory)).append("\n");
        sb.append("    productGroup: ").append(this.toIndentedString(this.productGroup)).append("\n");
        sb.append("    productSubcategory: ").append(this.toIndentedString(this.productSubcategory)).append("\n");
        sb.append("    replenishmentCategory: ").append(this.toIndentedString((Object)this.replenishmentCategory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplenishmentCategoryEnum {
        ALLOCATED("ALLOCATED"),
        BASIC_REPLENISHMENT("BASIC_REPLENISHMENT"),
        IN_SEASON("IN_SEASON"),
        LIMITED_REPLENISHMENT("LIMITED_REPLENISHMENT"),
        MANUFACTURER_OUT_OF_STOCK("MANUFACTURER_OUT_OF_STOCK"),
        NEW_PRODUCT("NEW_PRODUCT"),
        NON_REPLENISHABLE("NON_REPLENISHABLE"),
        NON_STOCKUPABLE("NON_STOCKUPABLE"),
        OBSOLETE("OBSOLETE"),
        PLANNED_REPLENISHMENT("PLANNED_REPLENISHMENT");

        private String value;

        private ReplenishmentCategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplenishmentCategoryEnum fromValue(String text) {
            for (ReplenishmentCategoryEnum b : ReplenishmentCategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ReplenishmentCategoryEnum> {
            public void write(JsonWriter jsonWriter, ReplenishmentCategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplenishmentCategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplenishmentCategoryEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

