/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Variation theme indicating the combination of Amazon item catalog attributes that define the variation family.")
public class ItemVariationTheme {
    @SerializedName(value="attributes")
    private List<String> attributes = null;
    @SerializedName(value="theme")
    private String theme = null;

    public ItemVariationTheme attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ItemVariationTheme addAttributesItem(String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="Names of the Amazon catalog item attributes associated with the variation theme.")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public ItemVariationTheme theme(String theme) {
        this.theme = theme;
        return this;
    }

    @ApiModelProperty(example="COLOR_NAME/STYLE_NAME", value="Variation theme indicating the combination of Amazon item catalog attributes that define the variation family.")
    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariationTheme itemVariationTheme = (ItemVariationTheme)o;
        return Objects.equals(this.attributes, itemVariationTheme.attributes) && Objects.equals(this.theme, itemVariationTheme.theme);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.theme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemVariationTheme {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString(this.theme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

