/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.amazon.spapi.model.catalogitems.ItemBrowseClassification;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Summary details of an Amazon catalog item for the indicated Amazon marketplace.")
public class ItemSummaryByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="browseClassification")
    private ItemBrowseClassification browseClassification = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="itemClassification")
    private ItemClassificationEnum itemClassification = null;
    @SerializedName(value="itemName")
    private String itemName = null;
    @SerializedName(value="manufacturer")
    private String manufacturer = null;
    @SerializedName(value="modelNumber")
    private String modelNumber = null;
    @SerializedName(value="packageQuantity")
    private Integer packageQuantity = null;
    @SerializedName(value="partNumber")
    private String partNumber = null;
    @SerializedName(value="size")
    private String size = null;
    @SerializedName(value="style")
    private String style = null;
    @SerializedName(value="websiteDisplayGroup")
    private String websiteDisplayGroup = null;

    public ItemSummaryByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemSummaryByMarketplace brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="Name of the brand associated with an Amazon catalog item.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ItemSummaryByMarketplace browseClassification(ItemBrowseClassification browseClassification) {
        this.browseClassification = browseClassification;
        return this;
    }

    @ApiModelProperty(value="Classification (browse node) associated with an Amazon catalog item.")
    public ItemBrowseClassification getBrowseClassification() {
        return this.browseClassification;
    }

    public void setBrowseClassification(ItemBrowseClassification browseClassification) {
        this.browseClassification = browseClassification;
    }

    public ItemSummaryByMarketplace color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Name of the color associated with an Amazon catalog item.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public ItemSummaryByMarketplace itemClassification(ItemClassificationEnum itemClassification) {
        this.itemClassification = itemClassification;
        return this;
    }

    @ApiModelProperty(value="Classification type associated with the Amazon catalog item.")
    public ItemClassificationEnum getItemClassification() {
        return this.itemClassification;
    }

    public void setItemClassification(ItemClassificationEnum itemClassification) {
        this.itemClassification = itemClassification;
    }

    public ItemSummaryByMarketplace itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @ApiModelProperty(value="Name, or title, associated with an Amazon catalog item.")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public ItemSummaryByMarketplace manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @ApiModelProperty(value="Name of the manufacturer associated with an Amazon catalog item.")
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public ItemSummaryByMarketplace modelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
        return this;
    }

    @ApiModelProperty(value="Model number associated with an Amazon catalog item.")
    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public ItemSummaryByMarketplace packageQuantity(Integer packageQuantity) {
        this.packageQuantity = packageQuantity;
        return this;
    }

    @ApiModelProperty(value="Quantity of an Amazon catalog item in one package.")
    public Integer getPackageQuantity() {
        return this.packageQuantity;
    }

    public void setPackageQuantity(Integer packageQuantity) {
        this.packageQuantity = packageQuantity;
    }

    public ItemSummaryByMarketplace partNumber(String partNumber) {
        this.partNumber = partNumber;
        return this;
    }

    @ApiModelProperty(value="Part number associated with an Amazon catalog item.")
    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String partNumber) {
        this.partNumber = partNumber;
    }

    public ItemSummaryByMarketplace size(String size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="Name of the size associated with an Amazon catalog item.")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public ItemSummaryByMarketplace style(String style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="Name of the style associated with an Amazon catalog item.")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public ItemSummaryByMarketplace websiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
        return this;
    }

    @ApiModelProperty(value="Name of the website display group associated with an Amazon catalog item.")
    public String getWebsiteDisplayGroup() {
        return this.websiteDisplayGroup;
    }

    public void setWebsiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSummaryByMarketplace itemSummaryByMarketplace = (ItemSummaryByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemSummaryByMarketplace.marketplaceId) && Objects.equals(this.brand, itemSummaryByMarketplace.brand) && Objects.equals(this.browseClassification, itemSummaryByMarketplace.browseClassification) && Objects.equals(this.color, itemSummaryByMarketplace.color) && Objects.equals((Object)this.itemClassification, (Object)itemSummaryByMarketplace.itemClassification) && Objects.equals(this.itemName, itemSummaryByMarketplace.itemName) && Objects.equals(this.manufacturer, itemSummaryByMarketplace.manufacturer) && Objects.equals(this.modelNumber, itemSummaryByMarketplace.modelNumber) && Objects.equals(this.packageQuantity, itemSummaryByMarketplace.packageQuantity) && Objects.equals(this.partNumber, itemSummaryByMarketplace.partNumber) && Objects.equals(this.size, itemSummaryByMarketplace.size) && Objects.equals(this.style, itemSummaryByMarketplace.style) && Objects.equals(this.websiteDisplayGroup, itemSummaryByMarketplace.websiteDisplayGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.brand, this.browseClassification, this.color, this.itemClassification, this.itemName, this.manufacturer, this.modelNumber, this.packageQuantity, this.partNumber, this.size, this.style, this.websiteDisplayGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSummaryByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    browseClassification: ").append(this.toIndentedString(this.browseClassification)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    itemClassification: ").append(this.toIndentedString((Object)this.itemClassification)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    manufacturer: ").append(this.toIndentedString(this.manufacturer)).append("\n");
        sb.append("    modelNumber: ").append(this.toIndentedString(this.modelNumber)).append("\n");
        sb.append("    packageQuantity: ").append(this.toIndentedString(this.packageQuantity)).append("\n");
        sb.append("    partNumber: ").append(this.toIndentedString(this.partNumber)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    websiteDisplayGroup: ").append(this.toIndentedString(this.websiteDisplayGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ItemClassificationEnum {
        BASE_PRODUCT("BASE_PRODUCT"),
        OTHER("OTHER"),
        PRODUCT_BUNDLE("PRODUCT_BUNDLE"),
        VARIATION_PARENT("VARIATION_PARENT");

        private String value;

        private ItemClassificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ItemClassificationEnum fromValue(String text) {
            for (ItemClassificationEnum b : ItemClassificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ItemClassificationEnum> {
            public void write(JsonWriter jsonWriter, ItemClassificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ItemClassificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ItemClassificationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

