/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.amazon.spapi.model.catalogitems.ItemRelationship;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Relationship details for the Amazon catalog item for the indicated Amazon marketplace.")
public class ItemRelationshipsByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="relationships")
    private List<ItemRelationship> relationships = new ArrayList<ItemRelationship>();

    public ItemRelationshipsByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemRelationshipsByMarketplace relationships(List<ItemRelationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    public ItemRelationshipsByMarketplace addRelationshipsItem(ItemRelationship relationshipsItem) {
        this.relationships.add(relationshipsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Relationships for the item.")
    public List<ItemRelationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<ItemRelationship> relationships) {
        this.relationships = relationships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRelationshipsByMarketplace itemRelationshipsByMarketplace = (ItemRelationshipsByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemRelationshipsByMarketplace.marketplaceId) && Objects.equals(this.relationships, itemRelationshipsByMarketplace.relationships);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.relationships);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemRelationshipsByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

