/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Image for an item in the Amazon catalog.")
public class ItemImage {
    @SerializedName(value="variant")
    private VariantEnum variant = null;
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="width")
    private Integer width = null;

    public ItemImage variant(VariantEnum variant) {
        this.variant = variant;
        return this;
    }

    @ApiModelProperty(example="MAIN", required=true, value="Variant of the image, such as `MAIN` or `PT01`.")
    public VariantEnum getVariant() {
        return this.variant;
    }

    public void setVariant(VariantEnum variant) {
        this.variant = variant;
    }

    public ItemImage link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(required=true, value="Link, or URL, for the image.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public ItemImage height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of the image in pixels.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ItemImage width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of the image in pixels.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemImage itemImage = (ItemImage)o;
        return Objects.equals((Object)this.variant, (Object)itemImage.variant) && Objects.equals(this.link, itemImage.link) && Objects.equals(this.height, itemImage.height) && Objects.equals(this.width, itemImage.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.variant, this.link, this.height, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemImage {\n");
        sb.append("    variant: ").append(this.toIndentedString((Object)this.variant)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VariantEnum {
        MAIN("MAIN"),
        PT01("PT01"),
        PT02("PT02"),
        PT03("PT03"),
        PT04("PT04"),
        PT05("PT05"),
        PT06("PT06"),
        PT07("PT07"),
        PT08("PT08"),
        SWCH("SWCH");

        private String value;

        private VariantEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VariantEnum fromValue(String text) {
            for (VariantEnum b : VariantEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VariantEnum> {
            public void write(JsonWriter jsonWriter, VariantEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VariantEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VariantEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

