/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Description of a classification that can be used to get more fine-grained search results.")
public class ClassificationRefinement {
    @SerializedName(value="numberOfResults")
    private Integer numberOfResults = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="classificationId")
    private String classificationId = null;

    public ClassificationRefinement numberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated number of results that would still be returned if refinement key applied.")
    public Integer getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
    }

    public ClassificationRefinement displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="Display name for the classification.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ClassificationRefinement classificationId(String classificationId) {
        this.classificationId = classificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier for the classification that can be used for search refinement purposes.")
    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationRefinement classificationRefinement = (ClassificationRefinement)o;
        return Objects.equals(this.numberOfResults, classificationRefinement.numberOfResults) && Objects.equals(this.displayName, classificationRefinement.displayName) && Objects.equals(this.classificationId, classificationRefinement.classificationId);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfResults, this.displayName, this.classificationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClassificationRefinement {\n");
        sb.append("    numberOfResults: ").append(this.toIndentedString(this.numberOfResults)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    classificationId: ").append(this.toIndentedString(this.classificationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

