/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Description of a brand that can be used to get more fine-grained search results.")
public class BrandRefinement {
    @SerializedName(value="numberOfResults")
    private Integer numberOfResults = null;
    @SerializedName(value="brandName")
    private String brandName = null;

    public BrandRefinement numberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated number of results that would still be returned if refinement key applied.")
    public Integer getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
    }

    public BrandRefinement brandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    @ApiModelProperty(required=true, value="Brand name. For display and can be used as a search refinement.")
    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandRefinement brandRefinement = (BrandRefinement)o;
        return Objects.equals(this.numberOfResults, brandRefinement.numberOfResults) && Objects.equals(this.brandName, brandRefinement.brandName);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfResults, this.brandName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrandRefinement {\n");
        sb.append("    numberOfResults: ").append(this.toIndentedString(this.numberOfResults)).append("\n");
        sb.append("    brandName: ").append(this.toIndentedString(this.brandName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

