/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.apluscontent;

import com.amazon.spapi.model.apluscontent.ContentBadgeSet;
import com.amazon.spapi.model.apluscontent.ContentStatus;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The metadata of an A+ Content document.")
public class ContentMetadata {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="status")
    private ContentStatus status = null;
    @SerializedName(value="badgeSet")
    private ContentBadgeSet badgeSet = null;
    @SerializedName(value="updateTime")
    private OffsetDateTime updateTime = null;

    public ContentMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The A+ Content document name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContentMetadata marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ContentMetadata status(ContentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ContentStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContentStatus status) {
        this.status = status;
    }

    public ContentMetadata badgeSet(ContentBadgeSet badgeSet) {
        this.badgeSet = badgeSet;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ContentBadgeSet getBadgeSet() {
        return this.badgeSet;
    }

    public void setBadgeSet(ContentBadgeSet badgeSet) {
        this.badgeSet = badgeSet;
    }

    public ContentMetadata updateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The approximate age of the A+ Content document and metadata.")
    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentMetadata contentMetadata = (ContentMetadata)o;
        return Objects.equals(this.name, contentMetadata.name) && Objects.equals(this.marketplaceId, contentMetadata.marketplaceId) && Objects.equals((Object)this.status, (Object)contentMetadata.status) && Objects.equals(this.badgeSet, contentMetadata.badgeSet) && Objects.equals(this.updateTime, contentMetadata.updateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.marketplaceId, this.status, this.badgeSet, this.updateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    badgeSet: ").append(this.toIndentedString(this.badgeSet)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

