/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.api;

import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.spapi.SellingPartnerAPIAA.AWSSigV4Signer;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.spapi.client.ApiCallback;
import com.amazon.spapi.client.ApiClient;
import com.amazon.spapi.client.ApiException;
import com.amazon.spapi.client.ApiResponse;
import com.amazon.spapi.client.Configuration;
import com.amazon.spapi.client.Pair;
import com.amazon.spapi.client.ProgressRequestBody;
import com.amazon.spapi.client.ProgressResponseBody;
import com.amazon.spapi.client.StringUtil;
import com.amazon.spapi.model.sales.GetOrderMetricsResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SalesApi {
    private ApiClient apiClient;

    SalesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SalesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getOrderMetricsCall(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sales/v1/orderMetrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("interval", interval));
        }
        if (granularityTimeZone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityTimeZone", granularityTimeZone));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularity", granularity));
        }
        if (buyerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("buyerType", buyerType));
        }
        if (fulfillmentNetwork != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fulfillmentNetwork", fulfillmentNetwork));
        }
        if (firstDayOfWeek != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("firstDayOfWeek", firstDayOfWeek));
        }
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (sku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sku", sku));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrderMetricsValidateBeforeCall(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getOrderMetrics(Async)");
        }
        if (interval == null) {
            throw new ApiException("Missing the required parameter 'interval' when calling getOrderMetrics(Async)");
        }
        if (granularity == null) {
            throw new ApiException("Missing the required parameter 'granularity' when calling getOrderMetrics(Async)");
        }
        Call call = this.getOrderMetricsCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, progressListener, progressRequestListener);
        return call;
    }

    public GetOrderMetricsResponse getOrderMetrics(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku) throws ApiException {
        ApiResponse<GetOrderMetricsResponse> resp = this.getOrderMetricsWithHttpInfo(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku);
        return resp.getData();
    }

    public ApiResponse<GetOrderMetricsResponse> getOrderMetricsWithHttpInfo(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku) throws ApiException {
        Call call = this.getOrderMetricsValidateBeforeCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, null, null);
        Type localVarReturnType = new TypeToken<GetOrderMetricsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrderMetricsAsync(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, final ApiCallback<GetOrderMetricsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrderMetricsValidateBeforeCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetOrderMetricsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class Builder {
        private AWSAuthenticationCredentials awsAuthenticationCredentials;
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider;

        public Builder awsAuthenticationCredentials(AWSAuthenticationCredentials awsAuthenticationCredentials) {
            this.awsAuthenticationCredentials = awsAuthenticationCredentials;
            return this;
        }

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder awsAuthenticationCredentialsProvider(AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
            this.awsAuthenticationCredentialsProvider = awsAuthenticationCredentialsProvider;
            return this;
        }

        public SalesApi build() {
            if (this.awsAuthenticationCredentials == null) {
                throw new RuntimeException("AWSAuthenticationCredentials not set");
            }
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            AWSSigV4Signer awsSigV4Signer = this.awsAuthenticationCredentialsProvider == null ? new AWSSigV4Signer(this.awsAuthenticationCredentials) : new AWSSigV4Signer(this.awsAuthenticationCredentials, this.awsAuthenticationCredentialsProvider);
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SalesApi(new ApiClient().setAWSSigV4Signer(awsSigV4Signer).setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint));
        }
    }
}

