/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.api;

import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.spapi.SellingPartnerAPIAA.AWSSigV4Signer;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.spapi.client.ApiCallback;
import com.amazon.spapi.client.ApiClient;
import com.amazon.spapi.client.ApiException;
import com.amazon.spapi.client.ApiResponse;
import com.amazon.spapi.client.Configuration;
import com.amazon.spapi.client.Pair;
import com.amazon.spapi.client.ProgressRequestBody;
import com.amazon.spapi.client.ProgressResponseBody;
import com.amazon.spapi.client.StringUtil;
import com.amazon.spapi.model.productpricing.GetOffersResponse;
import com.amazon.spapi.model.productpricing.GetPricingResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductPricingApi {
    private ApiClient apiClient;

    ProductPricingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductPricingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getCompetitivePricingCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/competitivePrice";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (asins != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Asins", asins));
        }
        if (skus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Skus", skus));
        }
        if (itemType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemType", itemType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCompetitivePricingValidateBeforeCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getCompetitivePricing(Async)");
        }
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling getCompetitivePricing(Async)");
        }
        Call call = this.getCompetitivePricingCall(marketplaceId, itemType, asins, skus, progressListener, progressRequestListener);
        return call;
    }

    public GetPricingResponse getCompetitivePricing(String marketplaceId, String itemType, List<String> asins, List<String> skus) throws ApiException {
        ApiResponse<GetPricingResponse> resp = this.getCompetitivePricingWithHttpInfo(marketplaceId, itemType, asins, skus);
        return resp.getData();
    }

    public ApiResponse<GetPricingResponse> getCompetitivePricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus) throws ApiException {
        Call call = this.getCompetitivePricingValidateBeforeCall(marketplaceId, itemType, asins, skus, null, null);
        Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCompetitivePricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, final ApiCallback<GetPricingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCompetitivePricingValidateBeforeCall(marketplaceId, itemType, asins, skus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getItemOffersCall(String marketplaceId, String itemCondition, String asin, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/items/{Asin}/offers".replaceAll("\\{Asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getItemOffersValidateBeforeCall(String marketplaceId, String itemCondition, String asin, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getItemOffers(Async)");
        }
        if (itemCondition == null) {
            throw new ApiException("Missing the required parameter 'itemCondition' when calling getItemOffers(Async)");
        }
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemOffers(Async)");
        }
        Call call = this.getItemOffersCall(marketplaceId, itemCondition, asin, progressListener, progressRequestListener);
        return call;
    }

    public GetOffersResponse getItemOffers(String marketplaceId, String itemCondition, String asin) throws ApiException {
        ApiResponse<GetOffersResponse> resp = this.getItemOffersWithHttpInfo(marketplaceId, itemCondition, asin);
        return resp.getData();
    }

    public ApiResponse<GetOffersResponse> getItemOffersWithHttpInfo(String marketplaceId, String itemCondition, String asin) throws ApiException {
        Call call = this.getItemOffersValidateBeforeCall(marketplaceId, itemCondition, asin, null, null);
        Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getItemOffersAsync(String marketplaceId, String itemCondition, String asin, final ApiCallback<GetOffersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getItemOffersValidateBeforeCall(marketplaceId, itemCondition, asin, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListingOffersCall(String marketplaceId, String itemCondition, String sellerSKU, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/listings/{SellerSKU}/offers".replaceAll("\\{SellerSKU\\}", this.apiClient.escapeString(sellerSKU.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListingOffersValidateBeforeCall(String marketplaceId, String itemCondition, String sellerSKU, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getListingOffers(Async)");
        }
        if (itemCondition == null) {
            throw new ApiException("Missing the required parameter 'itemCondition' when calling getListingOffers(Async)");
        }
        if (sellerSKU == null) {
            throw new ApiException("Missing the required parameter 'sellerSKU' when calling getListingOffers(Async)");
        }
        Call call = this.getListingOffersCall(marketplaceId, itemCondition, sellerSKU, progressListener, progressRequestListener);
        return call;
    }

    public GetOffersResponse getListingOffers(String marketplaceId, String itemCondition, String sellerSKU) throws ApiException {
        ApiResponse<GetOffersResponse> resp = this.getListingOffersWithHttpInfo(marketplaceId, itemCondition, sellerSKU);
        return resp.getData();
    }

    public ApiResponse<GetOffersResponse> getListingOffersWithHttpInfo(String marketplaceId, String itemCondition, String sellerSKU) throws ApiException {
        Call call = this.getListingOffersValidateBeforeCall(marketplaceId, itemCondition, sellerSKU, null, null);
        Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListingOffersAsync(String marketplaceId, String itemCondition, String sellerSKU, final ApiCallback<GetOffersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListingOffersValidateBeforeCall(marketplaceId, itemCondition, sellerSKU, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetOffersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPricingCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/products/pricing/v0/price";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MarketplaceId", marketplaceId));
        }
        if (asins != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Asins", asins));
        }
        if (skus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "Skus", skus));
        }
        if (itemType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemType", itemType));
        }
        if (itemCondition != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ItemCondition", itemCondition));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPricingValidateBeforeCall(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getPricing(Async)");
        }
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling getPricing(Async)");
        }
        Call call = this.getPricingCall(marketplaceId, itemType, asins, skus, itemCondition, progressListener, progressRequestListener);
        return call;
    }

    public GetPricingResponse getPricing(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition) throws ApiException {
        ApiResponse<GetPricingResponse> resp = this.getPricingWithHttpInfo(marketplaceId, itemType, asins, skus, itemCondition);
        return resp.getData();
    }

    public ApiResponse<GetPricingResponse> getPricingWithHttpInfo(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition) throws ApiException {
        Call call = this.getPricingValidateBeforeCall(marketplaceId, itemType, asins, skus, itemCondition, null, null);
        Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPricingAsync(String marketplaceId, String itemType, List<String> asins, List<String> skus, String itemCondition, final ApiCallback<GetPricingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPricingValidateBeforeCall(marketplaceId, itemType, asins, skus, itemCondition, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetPricingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class Builder {
        private AWSAuthenticationCredentials awsAuthenticationCredentials;
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider;

        public Builder awsAuthenticationCredentials(AWSAuthenticationCredentials awsAuthenticationCredentials) {
            this.awsAuthenticationCredentials = awsAuthenticationCredentials;
            return this;
        }

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder awsAuthenticationCredentialsProvider(AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
            this.awsAuthenticationCredentialsProvider = awsAuthenticationCredentialsProvider;
            return this;
        }

        public ProductPricingApi build() {
            if (this.awsAuthenticationCredentials == null) {
                throw new RuntimeException("AWSAuthenticationCredentials not set");
            }
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            AWSSigV4Signer awsSigV4Signer = this.awsAuthenticationCredentialsProvider == null ? new AWSSigV4Signer(this.awsAuthenticationCredentials) : new AWSSigV4Signer(this.awsAuthenticationCredentials, this.awsAuthenticationCredentialsProvider);
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ProductPricingApi(new ApiClient().setAWSSigV4Signer(awsSigV4Signer).setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint));
        }
    }
}

