/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.api;

import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.spapi.SellingPartnerAPIAA.AWSSigV4Signer;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.spapi.SellingPartnerAPIAA.RateLimitConfiguration;
import com.amazon.spapi.client.ApiCallback;
import com.amazon.spapi.client.ApiClient;
import com.amazon.spapi.client.ApiException;
import com.amazon.spapi.client.ApiResponse;
import com.amazon.spapi.client.Configuration;
import com.amazon.spapi.client.Pair;
import com.amazon.spapi.client.ProgressRequestBody;
import com.amazon.spapi.client.ProgressResponseBody;
import com.amazon.spapi.client.StringUtil;
import com.amazon.spapi.model.listingsitems.Item;
import com.amazon.spapi.model.listingsitems.ListingsItemPatchRequest;
import com.amazon.spapi.model.listingsitems.ListingsItemPutRequest;
import com.amazon.spapi.model.listingsitems.ListingsItemSubmissionResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ListingsApi {
    private ApiClient apiClient;

    ListingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ListingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling deleteListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling deleteListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling deleteListingsItem(Async)");
        }
        Call call = this.deleteListingsItemCall(sellerId, sku, marketplaceIds, issueLocale, progressListener, progressRequestListener);
        return call;
    }

    public ListingsItemSubmissionResponse deleteListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale) throws ApiException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.deleteListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> deleteListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale) throws ApiException {
        Call call = this.deleteListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, null, null);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, final ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling getListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling getListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getListingsItem(Async)");
        }
        Call call = this.getListingsItemCall(sellerId, sku, marketplaceIds, issueLocale, includedData, progressListener, progressRequestListener);
        return call;
    }

    public Item getListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData) throws ApiException {
        ApiResponse<Item> resp = this.getListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, includedData);
        return resp.getData();
    }

    public ApiResponse<Item> getListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData) throws ApiException {
        Call call = this.getListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, includedData, null, null);
        Type localVarReturnType = new TypeToken<Item>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, final ApiCallback<Item> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, includedData, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Item>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPatchRequest body, String issueLocale, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ListingsItemPatchRequest localVarPostBody = body;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPatchRequest body, String issueLocale, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling patchListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling patchListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling patchListingsItem(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchListingsItem(Async)");
        }
        Call call = this.patchListingsItemCall(sellerId, sku, marketplaceIds, body, issueLocale, progressListener, progressRequestListener);
        return call;
    }

    public ListingsItemSubmissionResponse patchListingsItem(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPatchRequest body, String issueLocale) throws ApiException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.patchListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, body, issueLocale);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> patchListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPatchRequest body, String issueLocale) throws ApiException {
        Call call = this.patchListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, body, issueLocale, null, null);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPatchRequest body, String issueLocale, final ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, body, issueLocale, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call putListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPutRequest body, String issueLocale, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ListingsItemPutRequest localVarPostBody = body;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPutRequest body, String issueLocale, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling putListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling putListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling putListingsItem(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling putListingsItem(Async)");
        }
        Call call = this.putListingsItemCall(sellerId, sku, marketplaceIds, body, issueLocale, progressListener, progressRequestListener);
        return call;
    }

    public ListingsItemSubmissionResponse putListingsItem(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPutRequest body, String issueLocale) throws ApiException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.putListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, body, issueLocale);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> putListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPutRequest body, String issueLocale) throws ApiException {
        Call call = this.putListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, body, issueLocale, null, null);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, ListingsItemPutRequest body, String issueLocale, final ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, body, issueLocale, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class Builder {
        private AWSAuthenticationCredentials awsAuthenticationCredentials;
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider;
        private RateLimitConfiguration rateLimitConfiguration;

        public Builder awsAuthenticationCredentials(AWSAuthenticationCredentials awsAuthenticationCredentials) {
            this.awsAuthenticationCredentials = awsAuthenticationCredentials;
            return this;
        }

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder awsAuthenticationCredentialsProvider(AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
            this.awsAuthenticationCredentialsProvider = awsAuthenticationCredentialsProvider;
            return this;
        }

        public Builder rateLimitConfigurationOnRequests(RateLimitConfiguration rateLimitConfiguration) {
            this.rateLimitConfiguration = rateLimitConfiguration;
            return this;
        }

        public Builder disableRateLimitOnRequests() {
            this.rateLimitConfiguration = null;
            return this;
        }

        public ListingsApi build() {
            if (this.awsAuthenticationCredentials == null) {
                throw new RuntimeException("AWSAuthenticationCredentials not set");
            }
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            AWSSigV4Signer awsSigV4Signer = this.awsAuthenticationCredentialsProvider == null ? new AWSSigV4Signer(this.awsAuthenticationCredentials) : new AWSSigV4Signer(this.awsAuthenticationCredentials, this.awsAuthenticationCredentialsProvider);
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ListingsApi(new ApiClient().setAWSSigV4Signer(awsSigV4Signer).setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint).setRateLimiter(this.rateLimitConfiguration));
        }
    }
}

