/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.api;

import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.spapi.SellingPartnerAPIAA.AWSSigV4Signer;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.spapi.client.ApiCallback;
import com.amazon.spapi.client.ApiClient;
import com.amazon.spapi.client.ApiException;
import com.amazon.spapi.client.ApiResponse;
import com.amazon.spapi.client.Configuration;
import com.amazon.spapi.client.Pair;
import com.amazon.spapi.client.ProgressRequestBody;
import com.amazon.spapi.client.ProgressResponseBody;
import com.amazon.spapi.client.StringUtil;
import com.amazon.spapi.model.fbainventory.GetInventorySummariesResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

public class FbaInventoryApi {
    private ApiClient apiClient;

    FbaInventoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FbaInventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getInventorySummariesCall(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String nextToken, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inventory/v1/summaries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (details != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("details", details));
        }
        if (granularityType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityType", granularityType));
        }
        if (granularityId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityId", granularityId));
        }
        if (startDateTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDateTime", startDateTime));
        }
        if (sellerSkus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sellerSkus", sellerSkus));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getInventorySummariesValidateBeforeCall(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String nextToken, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (granularityType == null) {
            throw new ApiException("Missing the required parameter 'granularityType' when calling getInventorySummaries(Async)");
        }
        if (granularityId == null) {
            throw new ApiException("Missing the required parameter 'granularityId' when calling getInventorySummaries(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getInventorySummaries(Async)");
        }
        Call call = this.getInventorySummariesCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, nextToken, progressListener, progressRequestListener);
        return call;
    }

    public GetInventorySummariesResponse getInventorySummaries(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String nextToken) throws ApiException {
        ApiResponse<GetInventorySummariesResponse> resp = this.getInventorySummariesWithHttpInfo(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, nextToken);
        return resp.getData();
    }

    public ApiResponse<GetInventorySummariesResponse> getInventorySummariesWithHttpInfo(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String nextToken) throws ApiException {
        Call call = this.getInventorySummariesValidateBeforeCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, nextToken, null, null);
        Type localVarReturnType = new TypeToken<GetInventorySummariesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getInventorySummariesAsync(String granularityType, String granularityId, List<String> marketplaceIds, Boolean details, OffsetDateTime startDateTime, List<String> sellerSkus, String nextToken, final ApiCallback<GetInventorySummariesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getInventorySummariesValidateBeforeCall(granularityType, granularityId, marketplaceIds, details, startDateTime, sellerSkus, nextToken, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetInventorySummariesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class Builder {
        private AWSAuthenticationCredentials awsAuthenticationCredentials;
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider;

        public Builder awsAuthenticationCredentials(AWSAuthenticationCredentials awsAuthenticationCredentials) {
            this.awsAuthenticationCredentials = awsAuthenticationCredentials;
            return this;
        }

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder awsAuthenticationCredentialsProvider(AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
            this.awsAuthenticationCredentialsProvider = awsAuthenticationCredentialsProvider;
            return this;
        }

        public FbaInventoryApi build() {
            if (this.awsAuthenticationCredentials == null) {
                throw new RuntimeException("AWSAuthenticationCredentials not set");
            }
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            AWSSigV4Signer awsSigV4Signer = this.awsAuthenticationCredentialsProvider == null ? new AWSSigV4Signer(this.awsAuthenticationCredentials) : new AWSSigV4Signer(this.awsAuthenticationCredentials, this.awsAuthenticationCredentialsProvider);
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FbaInventoryApi(new ApiClient().setAWSSigV4Signer(awsSigV4Signer).setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint));
        }
    }
}

