/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.SellingPartnerAPIAA;

import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenRequestMeta;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;

class LWAClient {
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String ACCESS_TOKEN_EXPIRES_IN = "expires_in";
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private String endpoint;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private LWAAccessTokenCache lwaAccessTokenCache;

    public void setLWAAccessTokenCache(LWAAccessTokenCache tokenCache) {
        this.lwaAccessTokenCache = tokenCache;
    }

    LWAClient(String endpoint) {
        this.endpoint = endpoint;
    }

    String getAccessToken(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) {
        if (this.lwaAccessTokenCache != null) {
            return this.getAccessTokenFromCache(lwaAccessTokenRequestMeta);
        }
        return this.getAccessTokenFromEndpoint(lwaAccessTokenRequestMeta);
    }

    String getAccessTokenFromCache(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) {
        String accessTokenCacheData = this.lwaAccessTokenCache.get(lwaAccessTokenRequestMeta);
        if (accessTokenCacheData != null) {
            return accessTokenCacheData;
        }
        return this.getAccessTokenFromEndpoint(lwaAccessTokenRequestMeta);
    }

    String getAccessTokenFromEndpoint(LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta) {
        String accessToken;
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)new Gson().toJson((Object)lwaAccessTokenRequestMeta));
        Request accessTokenRequest = new Request.Builder().url(this.endpoint).post(requestBody).build();
        try {
            Response response = this.okHttpClient.newCall(accessTokenRequest).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Unsuccessful LWA token exchange");
            }
            JsonObject responseJson = new JsonParser().parse(response.body().string()).getAsJsonObject();
            accessToken = responseJson.get(ACCESS_TOKEN_KEY).getAsString();
            if (this.lwaAccessTokenCache != null) {
                long timeToTokenexpiry = responseJson.get(ACCESS_TOKEN_EXPIRES_IN).getAsLong();
                this.lwaAccessTokenCache.put(lwaAccessTokenRequestMeta, accessToken, timeToTokenexpiry);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting LWA Access Token", e);
        }
        return accessToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }
}

