/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.SellingPartnerAPIAA;

import com.amazon.spapi.SellingPartnerAPIAA.LWAClientScopes;
import java.util.Arrays;
import java.util.HashSet;
import lombok.NonNull;

public class LWAAuthorizationCredentials {
    @NonNull
    private String clientId;
    @NonNull
    private String clientSecret;
    private String refreshToken;
    @NonNull
    private String endpoint;
    private LWAClientScopes scopes;

    LWAAuthorizationCredentials(@NonNull String clientId, @NonNull String clientSecret, String refreshToken, @NonNull String endpoint, LWAClientScopes scopes) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (clientSecret == null) {
            throw new NullPointerException("clientSecret is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
        this.endpoint = endpoint;
        this.scopes = scopes;
    }

    public static LWAAuthorizationCredentialsBuilder builder() {
        return new LWAAuthorizationCredentialsBuilder();
    }

    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    @NonNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @NonNull
    public String getEndpoint() {
        return this.endpoint;
    }

    public LWAClientScopes getScopes() {
        return this.scopes;
    }

    public void setClientId(@NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        this.clientId = clientId;
    }

    public void setClientSecret(@NonNull String clientSecret) {
        if (clientSecret == null) {
            throw new NullPointerException("clientSecret is marked non-null but is null");
        }
        this.clientSecret = clientSecret;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.endpoint = endpoint;
    }

    public void setScopes(LWAClientScopes scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LWAAuthorizationCredentials)) {
            return false;
        }
        LWAAuthorizationCredentials other = (LWAAuthorizationCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        LWAClientScopes this$scopes = this.getScopes();
        LWAClientScopes other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LWAAuthorizationCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        LWAClientScopes $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : $scopes.hashCode());
        return result;
    }

    public String toString() {
        return "LWAAuthorizationCredentials(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", refreshToken=" + this.getRefreshToken() + ", endpoint=" + this.getEndpoint() + ", scopes=" + this.getScopes() + ")";
    }

    public static class LWAAuthorizationCredentialsBuilder {
        private String clientId;
        private String clientSecret;
        private String refreshToken;
        private String endpoint;
        private LWAClientScopes scopes = new LWAClientScopes(new HashSet<String>());

        public LWAAuthorizationCredentialsBuilder withScope(String scope) {
            return this.withScopes(scope);
        }

        public LWAAuthorizationCredentialsBuilder withScopes(String ... scopes) {
            if (scopes != null) {
                Arrays.stream(scopes).forEach(this.scopes::addScope);
            }
            return this;
        }

        LWAAuthorizationCredentialsBuilder() {
        }

        public LWAAuthorizationCredentialsBuilder clientId(@NonNull String clientId) {
            if (clientId == null) {
                throw new NullPointerException("clientId is marked non-null but is null");
            }
            this.clientId = clientId;
            return this;
        }

        public LWAAuthorizationCredentialsBuilder clientSecret(@NonNull String clientSecret) {
            if (clientSecret == null) {
                throw new NullPointerException("clientSecret is marked non-null but is null");
            }
            this.clientSecret = clientSecret;
            return this;
        }

        public LWAAuthorizationCredentialsBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public LWAAuthorizationCredentialsBuilder endpoint(@NonNull String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public LWAAuthorizationCredentialsBuilder scopes(LWAClientScopes scopes) {
            this.scopes = scopes;
            return this;
        }

        public LWAAuthorizationCredentials build() {
            return new LWAAuthorizationCredentials(this.clientId, this.clientSecret, this.refreshToken, this.endpoint, this.scopes);
        }

        public String toString() {
            return "LWAAuthorizationCredentials.LWAAuthorizationCredentialsBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", refreshToken=" + this.refreshToken + ", endpoint=" + this.endpoint + ", scopes=" + this.scopes + ")";
        }
    }
}

