/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.tokens;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Model of a restricted resource.")
public class RestrictedResource {
    @SerializedName(value="method")
    private MethodEnum method = null;
    @SerializedName(value="path")
    private String path = null;

    public RestrictedResource method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="The HTTP method used with the restricted resource.")
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public RestrictedResource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="The path from a restricted operation. This could be:  - A specific path containing a seller's order ID, for example ```/orders/v0/orders/902-3159896-1390916/address```.  - A generic path that does not contain a seller's order ID, for example```/orders/v0/orders/{orderId}/address```).")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedResource restrictedResource = (RestrictedResource)o;
        return Objects.equals((Object)this.method, (Object)restrictedResource.method) && Objects.equals(this.path, restrictedResource.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.path});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestrictedResource {\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        GET("GET"),
        PUT("PUT"),
        POST("POST"),
        DELETE("DELETE");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String text) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

