/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ServiceType {
    GROUND("Amazon Shipping Ground"),
    STANDARD("Amazon Shipping Standard"),
    PREMIUM("Amazon Shipping Premium");

    private String value;

    private ServiceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceType fromValue(String text) {
        for (ServiceType b : ServiceType.values()) {
            if (!String.valueOf(b.value).equals(text)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<ServiceType> {
        public void write(JsonWriter jsonWriter, ServiceType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ServiceType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ServiceType.fromValue(String.valueOf(value));
        }
    }
}

