/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Currency;
import com.amazon.spapi.model.shipping.ServiceType;
import com.amazon.spapi.model.shipping.ShippingPromiseSet;
import com.amazon.spapi.model.shipping.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The specific rate for a shipping service, or null if no service available.")
public class ServiceRate {
    @SerializedName(value="totalCharge")
    private Currency totalCharge = null;
    @SerializedName(value="billableWeight")
    private Weight billableWeight = null;
    @SerializedName(value="serviceType")
    private ServiceType serviceType = null;
    @SerializedName(value="promise")
    private ShippingPromiseSet promise = null;

    public ServiceRate totalCharge(Currency totalCharge) {
        this.totalCharge = totalCharge;
        return this;
    }

    @ApiModelProperty(required=true, value="The total charge that will be billed for the rate.")
    public Currency getTotalCharge() {
        return this.totalCharge;
    }

    public void setTotalCharge(Currency totalCharge) {
        this.totalCharge = totalCharge;
    }

    public ServiceRate billableWeight(Weight billableWeight) {
        this.billableWeight = billableWeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The weight that was used to calculate the totalCharge.")
    public Weight getBillableWeight() {
        return this.billableWeight;
    }

    public void setBillableWeight(Weight billableWeight) {
        this.billableWeight = billableWeight;
    }

    public ServiceRate serviceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public ServiceRate promise(ShippingPromiseSet promise) {
        this.promise = promise;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ShippingPromiseSet getPromise() {
        return this.promise;
    }

    public void setPromise(ShippingPromiseSet promise) {
        this.promise = promise;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceRate serviceRate = (ServiceRate)o;
        return Objects.equals(this.totalCharge, serviceRate.totalCharge) && Objects.equals(this.billableWeight, serviceRate.billableWeight) && Objects.equals((Object)this.serviceType, (Object)serviceRate.serviceType) && Objects.equals(this.promise, serviceRate.promise);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.totalCharge, this.billableWeight, this.serviceType, this.promise});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceRate {\n");
        sb.append("    totalCharge: ").append(this.toIndentedString(this.totalCharge)).append("\n");
        sb.append("    billableWeight: ").append(this.toIndentedString(this.billableWeight)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    promise: ").append(this.toIndentedString(this.promise)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

