/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Currency;
import com.amazon.spapi.model.shipping.ServiceType;
import com.amazon.spapi.model.shipping.ShippingPromiseSet;
import com.amazon.spapi.model.shipping.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The available rate that can be used to send the shipment")
public class Rate {
    @SerializedName(value="rateId")
    private String rateId = null;
    @SerializedName(value="totalCharge")
    private Currency totalCharge = null;
    @SerializedName(value="billedWeight")
    private Weight billedWeight = null;
    @SerializedName(value="expirationTime")
    private OffsetDateTime expirationTime = null;
    @SerializedName(value="serviceType")
    private ServiceType serviceType = null;
    @SerializedName(value="promise")
    private ShippingPromiseSet promise = null;

    public Rate rateId(String rateId) {
        this.rateId = rateId;
        return this;
    }

    @ApiModelProperty(value="An identifier for the rate.")
    public String getRateId() {
        return this.rateId;
    }

    public void setRateId(String rateId) {
        this.rateId = rateId;
    }

    public Rate totalCharge(Currency totalCharge) {
        this.totalCharge = totalCharge;
        return this;
    }

    @ApiModelProperty(value="The total charge that will be billed for the rate.")
    public Currency getTotalCharge() {
        return this.totalCharge;
    }

    public void setTotalCharge(Currency totalCharge) {
        this.totalCharge = totalCharge;
    }

    public Rate billedWeight(Weight billedWeight) {
        this.billedWeight = billedWeight;
        return this;
    }

    @ApiModelProperty(value="The weight that was used to calculate the totalCharge.")
    public Weight getBilledWeight() {
        return this.billedWeight;
    }

    public void setBilledWeight(Weight billedWeight) {
        this.billedWeight = billedWeight;
    }

    public Rate expirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @ApiModelProperty(value="The time after which the offering will expire.")
    public OffsetDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Rate serviceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(value="")
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public Rate promise(ShippingPromiseSet promise) {
        this.promise = promise;
        return this;
    }

    @ApiModelProperty(value="")
    public ShippingPromiseSet getPromise() {
        return this.promise;
    }

    public void setPromise(ShippingPromiseSet promise) {
        this.promise = promise;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rate rate = (Rate)o;
        return Objects.equals(this.rateId, rate.rateId) && Objects.equals(this.totalCharge, rate.totalCharge) && Objects.equals(this.billedWeight, rate.billedWeight) && Objects.equals(this.expirationTime, rate.expirationTime) && Objects.equals((Object)this.serviceType, (Object)rate.serviceType) && Objects.equals(this.promise, rate.promise);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rateId, this.totalCharge, this.billedWeight, this.expirationTime, this.serviceType, this.promise});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rate {\n");
        sb.append("    rateId: ").append(this.toIndentedString(this.rateId)).append("\n");
        sb.append("    totalCharge: ").append(this.toIndentedString(this.totalCharge)).append("\n");
        sb.append("    billedWeight: ").append(this.toIndentedString(this.billedWeight)).append("\n");
        sb.append("    expirationTime: ").append(this.toIndentedString(this.expirationTime)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    promise: ").append(this.toIndentedString(this.promise)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

