/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="The label specification info.")
public class LabelSpecification {
    @SerializedName(value="labelFormat")
    private LabelFormatEnum labelFormat = null;
    @SerializedName(value="labelStockSize")
    private LabelStockSizeEnum labelStockSize = null;

    public LabelSpecification labelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="The format of the label. Enum of PNG only for now.")
    public LabelFormatEnum getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
    }

    public LabelSpecification labelStockSize(LabelStockSizeEnum labelStockSize) {
        this.labelStockSize = labelStockSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The label stock size specification in length and height. Enum of 4x6 only for now.")
    public LabelStockSizeEnum getLabelStockSize() {
        return this.labelStockSize;
    }

    public void setLabelStockSize(LabelStockSizeEnum labelStockSize) {
        this.labelStockSize = labelStockSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelSpecification labelSpecification = (LabelSpecification)o;
        return Objects.equals((Object)this.labelFormat, (Object)labelSpecification.labelFormat) && Objects.equals((Object)this.labelStockSize, (Object)labelSpecification.labelStockSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labelFormat, this.labelStockSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LabelSpecification {\n");
        sb.append("    labelFormat: ").append(this.toIndentedString((Object)this.labelFormat)).append("\n");
        sb.append("    labelStockSize: ").append(this.toIndentedString((Object)this.labelStockSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LabelStockSizeEnum {
        _4X6("4x6");

        private String value;

        private LabelStockSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LabelStockSizeEnum fromValue(String text) {
            for (LabelStockSizeEnum b : LabelStockSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LabelStockSizeEnum> {
            public void write(JsonWriter jsonWriter, LabelStockSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LabelStockSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LabelStockSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LabelFormatEnum {
        PNG("PNG");

        private String value;

        private LabelFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LabelFormatEnum fromValue(String text) {
            for (LabelFormatEnum b : LabelFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LabelFormatEnum> {
            public void write(JsonWriter jsonWriter, LabelFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LabelFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LabelFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

