/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.amazon.spapi.model.shipping.Currency;
import com.amazon.spapi.model.shipping.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Item in the container.")
public class ContainerItem {
    @SerializedName(value="quantity")
    private BigDecimal quantity = null;
    @SerializedName(value="unitPrice")
    private Currency unitPrice = null;
    @SerializedName(value="unitWeight")
    private Weight unitWeight = null;
    @SerializedName(value="title")
    private String title = null;

    public ContainerItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The quantity of the items of this type in the container.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public ContainerItem unitPrice(Currency unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The unit price of an item of this type (the total value of this item type in the container is unitPrice * quantity).")
    public Currency getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Currency unitPrice) {
        this.unitPrice = unitPrice;
    }

    public ContainerItem unitWeight(Weight unitWeight) {
        this.unitWeight = unitWeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The unit weight of an item of this type (the total weight of this item type in the container is unitWeight * quantity).")
    public Weight getUnitWeight() {
        return this.unitWeight;
    }

    public void setUnitWeight(Weight unitWeight) {
        this.unitWeight = unitWeight;
    }

    public ContainerItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="A descriptive title of the item.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerItem containerItem = (ContainerItem)o;
        return Objects.equals(this.quantity, containerItem.quantity) && Objects.equals(this.unitPrice, containerItem.unitPrice) && Objects.equals(this.unitWeight, containerItem.unitWeight) && Objects.equals(this.title, containerItem.title);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.unitPrice, this.unitWeight, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerItem {\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        sb.append("    unitWeight: ").append(this.toIndentedString(this.unitWeight)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

