/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.shipping;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The address.")
public class Address {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="addressLine1")
    private String addressLine1 = null;
    @SerializedName(value="addressLine2")
    private String addressLine2 = null;
    @SerializedName(value="addressLine3")
    private String addressLine3 = null;
    @SerializedName(value="stateOrRegion")
    private String stateOrRegion = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="postalCode")
    private String postalCode = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="copyEmails")
    private List<String> copyEmails = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the person, business or institution at that address.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @ApiModelProperty(required=true, value="First line of that address.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @ApiModelProperty(value="Additional address information, if required.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address addressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
        return this;
    }

    @ApiModelProperty(value="Additional address information, if required.")
    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public Address stateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public void setStateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the contact associated with the address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Address copyEmails(List<String> copyEmails) {
        this.copyEmails = copyEmails;
        return this;
    }

    public Address addCopyEmailsItem(String copyEmailsItem) {
        if (this.copyEmails == null) {
            this.copyEmails = new ArrayList<String>();
        }
        this.copyEmails.add(copyEmailsItem);
        return this;
    }

    @ApiModelProperty(value="The email cc addresses of the contact associated with the address.")
    public List<String> getCopyEmails() {
        return this.copyEmails;
    }

    public void setCopyEmails(List<String> copyEmails) {
        this.copyEmails = copyEmails;
    }

    public Address phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the person, business or institution located at that address.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.name, address.name) && Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.addressLine3, address.addressLine3) && Objects.equals(this.stateOrRegion, address.stateOrRegion) && Objects.equals(this.city, address.city) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.email, address.email) && Objects.equals(this.copyEmails, address.copyEmails) && Objects.equals(this.phoneNumber, address.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.addressLine1, this.addressLine2, this.addressLine3, this.stateOrRegion, this.city, this.countryCode, this.postalCode, this.email, this.copyEmails, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    stateOrRegion: ").append(this.toIndentedString(this.stateOrRegion)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    copyEmails: ").append(this.toIndentedString(this.copyEmails)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

