/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.services;

import com.amazon.spapi.model.services.ItemDeliveryPromise;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Delivery information for the item.")
public class ItemDelivery {
    @SerializedName(value="estimatedDeliveryDate")
    private OffsetDateTime estimatedDeliveryDate = null;
    @SerializedName(value="itemDeliveryPromise")
    private ItemDeliveryPromise itemDeliveryPromise = null;

    public ItemDelivery estimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="The date and time of the latest Estimated Delivery Date (EDD) of all the items with an EDD. In ISO 8601 format.")
    public OffsetDateTime getEstimatedDeliveryDate() {
        return this.estimatedDeliveryDate;
    }

    public void setEstimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
    }

    public ItemDelivery itemDeliveryPromise(ItemDeliveryPromise itemDeliveryPromise) {
        this.itemDeliveryPromise = itemDeliveryPromise;
        return this;
    }

    @ApiModelProperty(value="Promised delivery information for the item.")
    public ItemDeliveryPromise getItemDeliveryPromise() {
        return this.itemDeliveryPromise;
    }

    public void setItemDeliveryPromise(ItemDeliveryPromise itemDeliveryPromise) {
        this.itemDeliveryPromise = itemDeliveryPromise;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDelivery itemDelivery = (ItemDelivery)o;
        return Objects.equals(this.estimatedDeliveryDate, itemDelivery.estimatedDeliveryDate) && Objects.equals(this.itemDeliveryPromise, itemDelivery.itemDeliveryPromise);
    }

    public int hashCode() {
        return Objects.hash(this.estimatedDeliveryDate, this.itemDeliveryPromise);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemDelivery {\n");
        sb.append("    estimatedDeliveryDate: ").append(this.toIndentedString(this.estimatedDeliveryDate)).append("\n");
        sb.append("    itemDeliveryPromise: ").append(this.toIndentedString(this.itemDeliveryPromise)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

