/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.sellers;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Detailed information about an Amazon market where a seller can list items for sale and customers can view and purchase items.")
public class Marketplace {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="defaultCurrencyCode")
    private String defaultCurrencyCode = null;
    @SerializedName(value="defaultLanguageCode")
    private String defaultLanguageCode = null;
    @SerializedName(value="domainName")
    private String domainName = null;

    public Marketplace id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted marketplace value.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Marketplace name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Marketplace name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Marketplace countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO 3166-1 alpha-2 format country code of the marketplace.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Marketplace defaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO 4217 format currency code of the marketplace.")
    public String getDefaultCurrencyCode() {
        return this.defaultCurrencyCode;
    }

    public void setDefaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
    }

    public Marketplace defaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO 639-1 format language code of the marketplace.")
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public void setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
    }

    public Marketplace domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(required=true, value="The domain name of the marketplace.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marketplace marketplace = (Marketplace)o;
        return Objects.equals(this.id, marketplace.id) && Objects.equals(this.name, marketplace.name) && Objects.equals(this.countryCode, marketplace.countryCode) && Objects.equals(this.defaultCurrencyCode, marketplace.defaultCurrencyCode) && Objects.equals(this.defaultLanguageCode, marketplace.defaultLanguageCode) && Objects.equals(this.domainName, marketplace.domainName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.countryCode, this.defaultCurrencyCode, this.defaultLanguageCode, this.domainName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Marketplace {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    defaultCurrencyCode: ").append(this.toIndentedString(this.defaultCurrencyCode)).append("\n");
        sb.append("    defaultLanguageCode: ").append(this.toIndentedString(this.defaultLanguageCode)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

