/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.sales;

import com.amazon.spapi.model.sales.Money;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains order metrics.")
public class OrderMetricsInterval {
    @SerializedName(value="interval")
    private String interval = null;
    @SerializedName(value="unitCount")
    private Integer unitCount = null;
    @SerializedName(value="orderItemCount")
    private Integer orderItemCount = null;
    @SerializedName(value="orderCount")
    private Integer orderCount = null;
    @SerializedName(value="averageUnitPrice")
    private Money averageUnitPrice = null;
    @SerializedName(value="totalSales")
    private Money totalSales = null;

    public OrderMetricsInterval interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(required=true, value="The interval of time based on requested granularity (ex. Hour, Day, etc.) If this is the first or the last interval from the list, it might contain incomplete data if the requested interval doesn't align with the requested granularity (ex. request interval 2018-09-01T02:00:00Z--2018-09-04T19:00:00Z and granularity day will result in Sept 1st UTC day and Sept 4th UTC days having partial data).")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public OrderMetricsInterval unitCount(Integer unitCount) {
        this.unitCount = unitCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of units in orders based on the specified filters.")
    public Integer getUnitCount() {
        return this.unitCount;
    }

    public void setUnitCount(Integer unitCount) {
        this.unitCount = unitCount;
    }

    public OrderMetricsInterval orderItemCount(Integer orderItemCount) {
        this.orderItemCount = orderItemCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of order items based on the specified filters.")
    public Integer getOrderItemCount() {
        return this.orderItemCount;
    }

    public void setOrderItemCount(Integer orderItemCount) {
        this.orderItemCount = orderItemCount;
    }

    public OrderMetricsInterval orderCount(Integer orderCount) {
        this.orderCount = orderCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of orders based on the specified filters.")
    public Integer getOrderCount() {
        return this.orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public OrderMetricsInterval averageUnitPrice(Money averageUnitPrice) {
        this.averageUnitPrice = averageUnitPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The average price for an item based on the specified filters. Formula is totalSales/unitCount.")
    public Money getAverageUnitPrice() {
        return this.averageUnitPrice;
    }

    public void setAverageUnitPrice(Money averageUnitPrice) {
        this.averageUnitPrice = averageUnitPrice;
    }

    public OrderMetricsInterval totalSales(Money totalSales) {
        this.totalSales = totalSales;
        return this;
    }

    @ApiModelProperty(required=true, value="The total ordered product sales for all orders based on the specified filters.")
    public Money getTotalSales() {
        return this.totalSales;
    }

    public void setTotalSales(Money totalSales) {
        this.totalSales = totalSales;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderMetricsInterval orderMetricsInterval = (OrderMetricsInterval)o;
        return Objects.equals(this.interval, orderMetricsInterval.interval) && Objects.equals(this.unitCount, orderMetricsInterval.unitCount) && Objects.equals(this.orderItemCount, orderMetricsInterval.orderItemCount) && Objects.equals(this.orderCount, orderMetricsInterval.orderCount) && Objects.equals(this.averageUnitPrice, orderMetricsInterval.averageUnitPrice) && Objects.equals(this.totalSales, orderMetricsInterval.totalSales);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.unitCount, this.orderItemCount, this.orderCount, this.averageUnitPrice, this.totalSales);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderMetricsInterval {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    unitCount: ").append(this.toIndentedString(this.unitCount)).append("\n");
        sb.append("    orderItemCount: ").append(this.toIndentedString(this.orderItemCount)).append("\n");
        sb.append("    orderCount: ").append(this.toIndentedString(this.orderCount)).append("\n");
        sb.append("    averageUnitPrice: ").append(this.toIndentedString(this.averageUnitPrice)).append("\n");
        sb.append("    totalSales: ").append(this.toIndentedString(this.totalSales)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

