/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.reports;

import com.amazon.spapi.model.reports.ReportOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Information required to create the report.")
public class CreateReportSpecification {
    @SerializedName(value="reportOptions")
    private ReportOptions reportOptions = null;
    @SerializedName(value="reportType")
    private String reportType = null;
    @SerializedName(value="dataStartTime")
    private OffsetDateTime dataStartTime = null;
    @SerializedName(value="dataEndTime")
    private OffsetDateTime dataEndTime = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();

    public CreateReportSpecification reportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        return this;
    }

    @ApiModelProperty(value="")
    public ReportOptions getReportOptions() {
        return this.reportOptions;
    }

    public void setReportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
    }

    public CreateReportSpecification reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="The report type.")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public CreateReportSpecification dataStartTime(OffsetDateTime dataStartTime) {
        this.dataStartTime = dataStartTime;
        return this;
    }

    @ApiModelProperty(value="The start of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.")
    public OffsetDateTime getDataStartTime() {
        return this.dataStartTime;
    }

    public void setDataStartTime(OffsetDateTime dataStartTime) {
        this.dataStartTime = dataStartTime;
    }

    public CreateReportSpecification dataEndTime(OffsetDateTime dataEndTime) {
        this.dataEndTime = dataEndTime;
        return this;
    }

    @ApiModelProperty(value="The end of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.")
    public OffsetDateTime getDataEndTime() {
        return this.dataEndTime;
    }

    public void setDataEndTime(OffsetDateTime dataEndTime) {
        this.dataEndTime = dataEndTime;
    }

    public CreateReportSpecification marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public CreateReportSpecification addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of marketplace identifiers. The report document's contents will contain data for all of the specified marketplaces, unless the report type indicates otherwise.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReportSpecification createReportSpecification = (CreateReportSpecification)o;
        return Objects.equals(this.reportOptions, createReportSpecification.reportOptions) && Objects.equals(this.reportType, createReportSpecification.reportType) && Objects.equals(this.dataStartTime, createReportSpecification.dataStartTime) && Objects.equals(this.dataEndTime, createReportSpecification.dataEndTime) && Objects.equals(this.marketplaceIds, createReportSpecification.marketplaceIds);
    }

    public int hashCode() {
        return Objects.hash(this.reportOptions, this.reportType, this.dataStartTime, this.dataEndTime, this.marketplaceIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReportSpecification {\n");
        sb.append("    reportOptions: ").append(this.toIndentedString(this.reportOptions)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("    dataStartTime: ").append(this.toIndentedString(this.dataStartTime)).append("\n");
        sb.append("    dataEndTime: ").append(this.toIndentedString(this.dataEndTime)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

