/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productpricing;

import com.amazon.spapi.model.productpricing.MoneyType;
import com.amazon.spapi.model.productpricing.PriceType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OfferType {
    @SerializedName(value="BuyingPrice")
    private PriceType buyingPrice = null;
    @SerializedName(value="RegularPrice")
    private MoneyType regularPrice = null;
    @SerializedName(value="FulfillmentChannel")
    private String fulfillmentChannel = null;
    @SerializedName(value="ItemCondition")
    private String itemCondition = null;
    @SerializedName(value="ItemSubCondition")
    private String itemSubCondition = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;

    public OfferType buyingPrice(PriceType buyingPrice) {
        this.buyingPrice = buyingPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="Contains pricing information that includes promotions and contains the shipping cost.")
    public PriceType getBuyingPrice() {
        return this.buyingPrice;
    }

    public void setBuyingPrice(PriceType buyingPrice) {
        this.buyingPrice = buyingPrice;
    }

    public OfferType regularPrice(MoneyType regularPrice) {
        this.regularPrice = regularPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The current price excluding any promotions that apply to the product. Excludes the shipping cost.")
    public MoneyType getRegularPrice() {
        return this.regularPrice;
    }

    public void setRegularPrice(MoneyType regularPrice) {
        this.regularPrice = regularPrice;
    }

    public OfferType fulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="The fulfillment channel for the offer listing. Possible values:  * Amazon - Fulfilled by Amazon. * Merchant - Fulfilled by the seller.")
    public String getFulfillmentChannel() {
        return this.fulfillmentChannel;
    }

    public void setFulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
    }

    public OfferType itemCondition(String itemCondition) {
        this.itemCondition = itemCondition;
        return this;
    }

    @ApiModelProperty(required=true, value="The item condition for the offer listing. Possible values: New, Used, Collectible, Refurbished, or Club.")
    public String getItemCondition() {
        return this.itemCondition;
    }

    public void setItemCondition(String itemCondition) {
        this.itemCondition = itemCondition;
    }

    public OfferType itemSubCondition(String itemSubCondition) {
        this.itemSubCondition = itemSubCondition;
        return this;
    }

    @ApiModelProperty(required=true, value="The item subcondition for the offer listing. Possible values: New, Mint, Very Good, Good, Acceptable, Poor, Club, OEM, Warranty, Refurbished Warranty, Refurbished, Open Box, or Other.")
    public String getItemSubCondition() {
        return this.itemSubCondition;
    }

    public void setItemSubCondition(String itemSubCondition) {
        this.itemSubCondition = itemSubCondition;
    }

    public OfferType sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller stock keeping unit (SKU) of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferType offerType = (OfferType)o;
        return Objects.equals(this.buyingPrice, offerType.buyingPrice) && Objects.equals(this.regularPrice, offerType.regularPrice) && Objects.equals(this.fulfillmentChannel, offerType.fulfillmentChannel) && Objects.equals(this.itemCondition, offerType.itemCondition) && Objects.equals(this.itemSubCondition, offerType.itemSubCondition) && Objects.equals(this.sellerSKU, offerType.sellerSKU);
    }

    public int hashCode() {
        return Objects.hash(this.buyingPrice, this.regularPrice, this.fulfillmentChannel, this.itemCondition, this.itemSubCondition, this.sellerSKU);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferType {\n");
        sb.append("    buyingPrice: ").append(this.toIndentedString(this.buyingPrice)).append("\n");
        sb.append("    regularPrice: ").append(this.toIndentedString(this.regularPrice)).append("\n");
        sb.append("    fulfillmentChannel: ").append(this.toIndentedString(this.fulfillmentChannel)).append("\n");
        sb.append("    itemCondition: ").append(this.toIndentedString(this.itemCondition)).append("\n");
        sb.append("    itemSubCondition: ").append(this.toIndentedString(this.itemSubCondition)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

