/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.productpricing;

import com.amazon.spapi.model.productpricing.PriceType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CompetitivePriceType {
    @SerializedName(value="CompetitivePriceId")
    private String competitivePriceId = null;
    @SerializedName(value="Price")
    private PriceType price = null;
    @SerializedName(value="condition")
    private String condition = null;
    @SerializedName(value="subcondition")
    private String subcondition = null;
    @SerializedName(value="belongsToRequester")
    private Boolean belongsToRequester = null;

    public CompetitivePriceType competitivePriceId(String competitivePriceId) {
        this.competitivePriceId = competitivePriceId;
        return this;
    }

    @ApiModelProperty(required=true, value="The pricing model for each price that is returned.  Possible values:  * 1 - New Buy Box Price. * 2 - Used Buy Box Price.")
    public String getCompetitivePriceId() {
        return this.competitivePriceId;
    }

    public void setCompetitivePriceId(String competitivePriceId) {
        this.competitivePriceId = competitivePriceId;
    }

    public CompetitivePriceType price(PriceType price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="Pricing information for a given CompetitivePriceId value.")
    public PriceType getPrice() {
        return this.price;
    }

    public void setPrice(PriceType price) {
        this.price = price;
    }

    public CompetitivePriceType condition(String condition) {
        this.condition = condition;
        return this;
    }

    @ApiModelProperty(value="Indicates the condition of the item whose pricing information is returned. Possible values are: New, Used, Collectible, Refurbished, or Club.")
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public CompetitivePriceType subcondition(String subcondition) {
        this.subcondition = subcondition;
        return this;
    }

    @ApiModelProperty(value="Indicates the subcondition of the item whose pricing information is returned. Possible values are: New, Mint, Very Good, Good, Acceptable, Poor, Club, OEM, Warranty, Refurbished Warranty, Refurbished, Open Box, or Other.")
    public String getSubcondition() {
        return this.subcondition;
    }

    public void setSubcondition(String subcondition) {
        this.subcondition = subcondition;
    }

    public CompetitivePriceType belongsToRequester(Boolean belongsToRequester) {
        this.belongsToRequester = belongsToRequester;
        return this;
    }

    @ApiModelProperty(value=" Indicates whether or not the pricing information is for an offer listing that belongs to the requester. The requester is the seller associated with the SellerId that was submitted with the request. Possible values are: true and false.")
    public Boolean isBelongsToRequester() {
        return this.belongsToRequester;
    }

    public void setBelongsToRequester(Boolean belongsToRequester) {
        this.belongsToRequester = belongsToRequester;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompetitivePriceType competitivePriceType = (CompetitivePriceType)o;
        return Objects.equals(this.competitivePriceId, competitivePriceType.competitivePriceId) && Objects.equals(this.price, competitivePriceType.price) && Objects.equals(this.condition, competitivePriceType.condition) && Objects.equals(this.subcondition, competitivePriceType.subcondition) && Objects.equals(this.belongsToRequester, competitivePriceType.belongsToRequester);
    }

    public int hashCode() {
        return Objects.hash(this.competitivePriceId, this.price, this.condition, this.subcondition, this.belongsToRequester);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompetitivePriceType {\n");
        sb.append("    competitivePriceId: ").append(this.toIndentedString(this.competitivePriceId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    subcondition: ").append(this.toIndentedString(this.subcondition)).append("\n");
        sb.append("    belongsToRequester: ").append(this.toIndentedString(this.belongsToRequester)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

