/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.orders;

import com.amazon.spapi.model.orders.Address;
import com.amazon.spapi.model.orders.AutomatedShippingSettings;
import com.amazon.spapi.model.orders.BuyerInfo;
import com.amazon.spapi.model.orders.BuyerTaxInformation;
import com.amazon.spapi.model.orders.FulfillmentInstruction;
import com.amazon.spapi.model.orders.MarketplaceTaxInfo;
import com.amazon.spapi.model.orders.Money;
import com.amazon.spapi.model.orders.PaymentExecutionDetailItemList;
import com.amazon.spapi.model.orders.PaymentMethodDetailItemList;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Order information.")
public class Order {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="PurchaseDate")
    private String purchaseDate = null;
    @SerializedName(value="LastUpdateDate")
    private String lastUpdateDate = null;
    @SerializedName(value="OrderStatus")
    private OrderStatusEnum orderStatus = null;
    @SerializedName(value="FulfillmentChannel")
    private FulfillmentChannelEnum fulfillmentChannel = null;
    @SerializedName(value="SalesChannel")
    private String salesChannel = null;
    @SerializedName(value="OrderChannel")
    private String orderChannel = null;
    @SerializedName(value="ShipServiceLevel")
    private String shipServiceLevel = null;
    @SerializedName(value="OrderTotal")
    private Money orderTotal = null;
    @SerializedName(value="NumberOfItemsShipped")
    private Integer numberOfItemsShipped = null;
    @SerializedName(value="NumberOfItemsUnshipped")
    private Integer numberOfItemsUnshipped = null;
    @SerializedName(value="PaymentExecutionDetail")
    private PaymentExecutionDetailItemList paymentExecutionDetail = null;
    @SerializedName(value="PaymentMethod")
    private PaymentMethodEnum paymentMethod = null;
    @SerializedName(value="PaymentMethodDetails")
    private PaymentMethodDetailItemList paymentMethodDetails = null;
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="ShipmentServiceLevelCategory")
    private String shipmentServiceLevelCategory = null;
    @SerializedName(value="EasyShipShipmentStatus")
    private String easyShipShipmentStatus = null;
    @SerializedName(value="CbaDisplayableShippingLabel")
    private String cbaDisplayableShippingLabel = null;
    @SerializedName(value="OrderType")
    private OrderTypeEnum orderType = null;
    @SerializedName(value="EarliestShipDate")
    private String earliestShipDate = null;
    @SerializedName(value="LatestShipDate")
    private String latestShipDate = null;
    @SerializedName(value="EarliestDeliveryDate")
    private String earliestDeliveryDate = null;
    @SerializedName(value="LatestDeliveryDate")
    private String latestDeliveryDate = null;
    @SerializedName(value="IsBusinessOrder")
    private Boolean isBusinessOrder = null;
    @SerializedName(value="IsPrime")
    private Boolean isPrime = null;
    @SerializedName(value="IsPremiumOrder")
    private Boolean isPremiumOrder = null;
    @SerializedName(value="IsGlobalExpressEnabled")
    private Boolean isGlobalExpressEnabled = null;
    @SerializedName(value="ReplacedOrderId")
    private String replacedOrderId = null;
    @SerializedName(value="IsReplacementOrder")
    private Boolean isReplacementOrder = null;
    @SerializedName(value="PromiseResponseDueDate")
    private String promiseResponseDueDate = null;
    @SerializedName(value="IsEstimatedShipDateSet")
    private Boolean isEstimatedShipDateSet = null;
    @SerializedName(value="IsSoldByAB")
    private Boolean isSoldByAB = null;
    @SerializedName(value="IsIBA")
    private Boolean isIBA = null;
    @SerializedName(value="DefaultShipFromLocationAddress")
    private Address defaultShipFromLocationAddress = null;
    @SerializedName(value="BuyerInvoicePreference")
    private BuyerInvoicePreferenceEnum buyerInvoicePreference = null;
    @SerializedName(value="BuyerTaxInformation")
    private BuyerTaxInformation buyerTaxInformation = null;
    @SerializedName(value="FulfillmentInstruction")
    private FulfillmentInstruction fulfillmentInstruction = null;
    @SerializedName(value="IsISPU")
    private Boolean isISPU = null;
    @SerializedName(value="IsAccessPointOrder")
    private Boolean isAccessPointOrder = null;
    @SerializedName(value="MarketplaceTaxInfo")
    private MarketplaceTaxInfo marketplaceTaxInfo = null;
    @SerializedName(value="SellerDisplayName")
    private String sellerDisplayName = null;
    @SerializedName(value="ShippingAddress")
    private Address shippingAddress = null;
    @SerializedName(value="BuyerInfo")
    private BuyerInfo buyerInfo = null;
    @SerializedName(value="AutomatedShippingSettings")
    private AutomatedShippingSettings automatedShippingSettings = null;
    @SerializedName(value="HasRegulatedItems")
    private Boolean hasRegulatedItems = null;

    public Order amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="An Amazon-defined order identifier, in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public Order sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @ApiModelProperty(value="A seller-defined order identifier.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public Order purchaseDate(String purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the order was created.")
    public String getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(String purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public Order lastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the order was last updated.  __Note__: LastUpdateDate is returned with an incorrect date for orders that were last updated before 2009-04-01.")
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public Order orderStatus(OrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The current order status.")
    public OrderStatusEnum getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(OrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Order fulfillmentChannel(FulfillmentChannelEnum fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
        return this;
    }

    @ApiModelProperty(value="Whether the order was fulfilled by Amazon (AFN) or by the seller (MFN).")
    public FulfillmentChannelEnum getFulfillmentChannel() {
        return this.fulfillmentChannel;
    }

    public void setFulfillmentChannel(FulfillmentChannelEnum fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
    }

    public Order salesChannel(String salesChannel) {
        this.salesChannel = salesChannel;
        return this;
    }

    @ApiModelProperty(value="The sales channel of the first item in the order.")
    public String getSalesChannel() {
        return this.salesChannel;
    }

    public void setSalesChannel(String salesChannel) {
        this.salesChannel = salesChannel;
    }

    public Order orderChannel(String orderChannel) {
        this.orderChannel = orderChannel;
        return this;
    }

    @ApiModelProperty(value="The order channel of the first item in the order.")
    public String getOrderChannel() {
        return this.orderChannel;
    }

    public void setOrderChannel(String orderChannel) {
        this.orderChannel = orderChannel;
    }

    public Order shipServiceLevel(String shipServiceLevel) {
        this.shipServiceLevel = shipServiceLevel;
        return this;
    }

    @ApiModelProperty(value="The shipment service level of the order.")
    public String getShipServiceLevel() {
        return this.shipServiceLevel;
    }

    public void setShipServiceLevel(String shipServiceLevel) {
        this.shipServiceLevel = shipServiceLevel;
    }

    public Order orderTotal(Money orderTotal) {
        this.orderTotal = orderTotal;
        return this;
    }

    @ApiModelProperty(value="The total charge for this order.")
    public Money getOrderTotal() {
        return this.orderTotal;
    }

    public void setOrderTotal(Money orderTotal) {
        this.orderTotal = orderTotal;
    }

    public Order numberOfItemsShipped(Integer numberOfItemsShipped) {
        this.numberOfItemsShipped = numberOfItemsShipped;
        return this;
    }

    @ApiModelProperty(value="The number of items shipped.")
    public Integer getNumberOfItemsShipped() {
        return this.numberOfItemsShipped;
    }

    public void setNumberOfItemsShipped(Integer numberOfItemsShipped) {
        this.numberOfItemsShipped = numberOfItemsShipped;
    }

    public Order numberOfItemsUnshipped(Integer numberOfItemsUnshipped) {
        this.numberOfItemsUnshipped = numberOfItemsUnshipped;
        return this;
    }

    @ApiModelProperty(value="The number of items unshipped.")
    public Integer getNumberOfItemsUnshipped() {
        return this.numberOfItemsUnshipped;
    }

    public void setNumberOfItemsUnshipped(Integer numberOfItemsUnshipped) {
        this.numberOfItemsUnshipped = numberOfItemsUnshipped;
    }

    public Order paymentExecutionDetail(PaymentExecutionDetailItemList paymentExecutionDetail) {
        this.paymentExecutionDetail = paymentExecutionDetail;
        return this;
    }

    @ApiModelProperty(value="Information about sub-payment methods for a Cash On Delivery (COD) order.  __Note__: For a COD order that is paid for using one sub-payment method, one PaymentExecutionDetailItem object is returned, with PaymentExecutionDetailItem/PaymentMethod = COD. For a COD order that is paid for using multiple sub-payment methods, two or more PaymentExecutionDetailItem objects are returned.")
    public PaymentExecutionDetailItemList getPaymentExecutionDetail() {
        return this.paymentExecutionDetail;
    }

    public void setPaymentExecutionDetail(PaymentExecutionDetailItemList paymentExecutionDetail) {
        this.paymentExecutionDetail = paymentExecutionDetail;
    }

    public Order paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method for the order. This property is limited to Cash On Delivery (COD) and Convenience Store (CVS) payment methods. Unless you need the specific COD payment information provided by the PaymentExecutionDetailItem object, we recommend using the PaymentMethodDetails property to get payment method information.")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Order paymentMethodDetails(PaymentMethodDetailItemList paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
        return this;
    }

    @ApiModelProperty(value="A list of payment methods for the order.")
    public PaymentMethodDetailItemList getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    public void setPaymentMethodDetails(PaymentMethodDetailItemList paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    public Order marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the marketplace where the order was placed.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public Order shipmentServiceLevelCategory(String shipmentServiceLevelCategory) {
        this.shipmentServiceLevelCategory = shipmentServiceLevelCategory;
        return this;
    }

    @ApiModelProperty(value="The shipment service level category of the order.  Possible values: Expedited, FreeEconomy, NextDay, SameDay, SecondDay, Scheduled, Standard.")
    public String getShipmentServiceLevelCategory() {
        return this.shipmentServiceLevelCategory;
    }

    public void setShipmentServiceLevelCategory(String shipmentServiceLevelCategory) {
        this.shipmentServiceLevelCategory = shipmentServiceLevelCategory;
    }

    public Order easyShipShipmentStatus(String easyShipShipmentStatus) {
        this.easyShipShipmentStatus = easyShipShipmentStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the Amazon Easy Ship order. This property is included only for Amazon Easy Ship orders.  Possible values: PendingPickUp, LabelCanceled, PickedUp, OutForDelivery, Damaged, Delivered, RejectedByBuyer, Undeliverable, ReturnedToSeller, ReturningToSeller.")
    public String getEasyShipShipmentStatus() {
        return this.easyShipShipmentStatus;
    }

    public void setEasyShipShipmentStatus(String easyShipShipmentStatus) {
        this.easyShipShipmentStatus = easyShipShipmentStatus;
    }

    public Order cbaDisplayableShippingLabel(String cbaDisplayableShippingLabel) {
        this.cbaDisplayableShippingLabel = cbaDisplayableShippingLabel;
        return this;
    }

    @ApiModelProperty(value="Custom ship label for Checkout by Amazon (CBA).")
    public String getCbaDisplayableShippingLabel() {
        return this.cbaDisplayableShippingLabel;
    }

    public void setCbaDisplayableShippingLabel(String cbaDisplayableShippingLabel) {
        this.cbaDisplayableShippingLabel = cbaDisplayableShippingLabel;
    }

    public Order orderType(OrderTypeEnum orderType) {
        this.orderType = orderType;
        return this;
    }

    @ApiModelProperty(value="The type of the order.")
    public OrderTypeEnum getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderTypeEnum orderType) {
        this.orderType = orderType;
    }

    public Order earliestShipDate(String earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
        return this;
    }

    @ApiModelProperty(value="The start of the time period within which you have committed to ship the order. In ISO 8601 date time format. Returned only for seller-fulfilled orders.  __Note__: EarliestShipDate might not be returned for orders placed before February 1, 2013.")
    public String getEarliestShipDate() {
        return this.earliestShipDate;
    }

    public void setEarliestShipDate(String earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
    }

    public Order latestShipDate(String latestShipDate) {
        this.latestShipDate = latestShipDate;
        return this;
    }

    @ApiModelProperty(value="The end of the time period within which you have committed to ship the order. In ISO 8601 date time format. Returned only for seller-fulfilled orders.  __Note__: LatestShipDate might not be returned for orders placed before February 1, 2013.")
    public String getLatestShipDate() {
        return this.latestShipDate;
    }

    public void setLatestShipDate(String latestShipDate) {
        this.latestShipDate = latestShipDate;
    }

    public Order earliestDeliveryDate(String earliestDeliveryDate) {
        this.earliestDeliveryDate = earliestDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="The start of the time period within which you have committed to fulfill the order. In ISO 8601 date time format. Returned only for seller-fulfilled orders.")
    public String getEarliestDeliveryDate() {
        return this.earliestDeliveryDate;
    }

    public void setEarliestDeliveryDate(String earliestDeliveryDate) {
        this.earliestDeliveryDate = earliestDeliveryDate;
    }

    public Order latestDeliveryDate(String latestDeliveryDate) {
        this.latestDeliveryDate = latestDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="The end of the time period within which you have committed to fulfill the order. In ISO 8601 date time format. Returned only for seller-fulfilled orders that do not have a PendingAvailability, Pending, or Canceled status.")
    public String getLatestDeliveryDate() {
        return this.latestDeliveryDate;
    }

    public void setLatestDeliveryDate(String latestDeliveryDate) {
        this.latestDeliveryDate = latestDeliveryDate;
    }

    public Order isBusinessOrder(Boolean isBusinessOrder) {
        this.isBusinessOrder = isBusinessOrder;
        return this;
    }

    @ApiModelProperty(value="When true, the order is an Amazon Business order. An Amazon Business order is an order where the buyer is a Verified Business Buyer.")
    public Boolean isIsBusinessOrder() {
        return this.isBusinessOrder;
    }

    public void setIsBusinessOrder(Boolean isBusinessOrder) {
        this.isBusinessOrder = isBusinessOrder;
    }

    public Order isPrime(Boolean isPrime) {
        this.isPrime = isPrime;
        return this;
    }

    @ApiModelProperty(value="When true, the order is a seller-fulfilled Amazon Prime order.")
    public Boolean isIsPrime() {
        return this.isPrime;
    }

    public void setIsPrime(Boolean isPrime) {
        this.isPrime = isPrime;
    }

    public Order isPremiumOrder(Boolean isPremiumOrder) {
        this.isPremiumOrder = isPremiumOrder;
        return this;
    }

    @ApiModelProperty(value="When true, the order has a Premium Shipping Service Level Agreement. For more information about Premium Shipping orders, see \"Premium Shipping Options\" in the Seller Central Help for your marketplace.")
    public Boolean isIsPremiumOrder() {
        return this.isPremiumOrder;
    }

    public void setIsPremiumOrder(Boolean isPremiumOrder) {
        this.isPremiumOrder = isPremiumOrder;
    }

    public Order isGlobalExpressEnabled(Boolean isGlobalExpressEnabled) {
        this.isGlobalExpressEnabled = isGlobalExpressEnabled;
        return this;
    }

    @ApiModelProperty(value="When true, the order is a GlobalExpress order.")
    public Boolean isIsGlobalExpressEnabled() {
        return this.isGlobalExpressEnabled;
    }

    public void setIsGlobalExpressEnabled(Boolean isGlobalExpressEnabled) {
        this.isGlobalExpressEnabled = isGlobalExpressEnabled;
    }

    public Order replacedOrderId(String replacedOrderId) {
        this.replacedOrderId = replacedOrderId;
        return this;
    }

    @ApiModelProperty(value="The order ID value for the order that is being replaced. Returned only if IsReplacementOrder = true.")
    public String getReplacedOrderId() {
        return this.replacedOrderId;
    }

    public void setReplacedOrderId(String replacedOrderId) {
        this.replacedOrderId = replacedOrderId;
    }

    public Order isReplacementOrder(Boolean isReplacementOrder) {
        this.isReplacementOrder = isReplacementOrder;
        return this;
    }

    @ApiModelProperty(value="When true, this is a replacement order.")
    public Boolean isIsReplacementOrder() {
        return this.isReplacementOrder;
    }

    public void setIsReplacementOrder(Boolean isReplacementOrder) {
        this.isReplacementOrder = isReplacementOrder;
    }

    public Order promiseResponseDueDate(String promiseResponseDueDate) {
        this.promiseResponseDueDate = promiseResponseDueDate;
        return this;
    }

    @ApiModelProperty(value="Indicates the date by which the seller must respond to the buyer with an estimated ship date. Returned only for Sourcing on Demand orders.")
    public String getPromiseResponseDueDate() {
        return this.promiseResponseDueDate;
    }

    public void setPromiseResponseDueDate(String promiseResponseDueDate) {
        this.promiseResponseDueDate = promiseResponseDueDate;
    }

    public Order isEstimatedShipDateSet(Boolean isEstimatedShipDateSet) {
        this.isEstimatedShipDateSet = isEstimatedShipDateSet;
        return this;
    }

    @ApiModelProperty(value="When true, the estimated ship date is set for the order. Returned only for Sourcing on Demand orders.")
    public Boolean isIsEstimatedShipDateSet() {
        return this.isEstimatedShipDateSet;
    }

    public void setIsEstimatedShipDateSet(Boolean isEstimatedShipDateSet) {
        this.isEstimatedShipDateSet = isEstimatedShipDateSet;
    }

    public Order isSoldByAB(Boolean isSoldByAB) {
        this.isSoldByAB = isSoldByAB;
        return this;
    }

    @ApiModelProperty(value="When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.")
    public Boolean isIsSoldByAB() {
        return this.isSoldByAB;
    }

    public void setIsSoldByAB(Boolean isSoldByAB) {
        this.isSoldByAB = isSoldByAB;
    }

    public Order isIBA(Boolean isIBA) {
        this.isIBA = isIBA;
        return this;
    }

    @ApiModelProperty(value="When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.")
    public Boolean isIsIBA() {
        return this.isIBA;
    }

    public void setIsIBA(Boolean isIBA) {
        this.isIBA = isIBA;
    }

    public Order defaultShipFromLocationAddress(Address defaultShipFromLocationAddress) {
        this.defaultShipFromLocationAddress = defaultShipFromLocationAddress;
        return this;
    }

    @ApiModelProperty(value="The recommended location for the seller to ship the items from. It is calculated at checkout. The seller may or may not choose to ship from this location.")
    public Address getDefaultShipFromLocationAddress() {
        return this.defaultShipFromLocationAddress;
    }

    public void setDefaultShipFromLocationAddress(Address defaultShipFromLocationAddress) {
        this.defaultShipFromLocationAddress = defaultShipFromLocationAddress;
    }

    public Order buyerInvoicePreference(BuyerInvoicePreferenceEnum buyerInvoicePreference) {
        this.buyerInvoicePreference = buyerInvoicePreference;
        return this;
    }

    @ApiModelProperty(value="The buyer's invoicing preference. Available only in the TR marketplace.")
    public BuyerInvoicePreferenceEnum getBuyerInvoicePreference() {
        return this.buyerInvoicePreference;
    }

    public void setBuyerInvoicePreference(BuyerInvoicePreferenceEnum buyerInvoicePreference) {
        this.buyerInvoicePreference = buyerInvoicePreference;
    }

    public Order buyerTaxInformation(BuyerTaxInformation buyerTaxInformation) {
        this.buyerTaxInformation = buyerTaxInformation;
        return this;
    }

    @ApiModelProperty(value="Contains the business invoice tax information.")
    public BuyerTaxInformation getBuyerTaxInformation() {
        return this.buyerTaxInformation;
    }

    public void setBuyerTaxInformation(BuyerTaxInformation buyerTaxInformation) {
        this.buyerTaxInformation = buyerTaxInformation;
    }

    public Order fulfillmentInstruction(FulfillmentInstruction fulfillmentInstruction) {
        this.fulfillmentInstruction = fulfillmentInstruction;
        return this;
    }

    @ApiModelProperty(value="Contains the instructions about the fulfillment like where should it be fulfilled from.")
    public FulfillmentInstruction getFulfillmentInstruction() {
        return this.fulfillmentInstruction;
    }

    public void setFulfillmentInstruction(FulfillmentInstruction fulfillmentInstruction) {
        this.fulfillmentInstruction = fulfillmentInstruction;
    }

    public Order isISPU(Boolean isISPU) {
        this.isISPU = isISPU;
        return this;
    }

    @ApiModelProperty(value="When true, this order is marked to be picked up from a store rather than delivered.")
    public Boolean isIsISPU() {
        return this.isISPU;
    }

    public void setIsISPU(Boolean isISPU) {
        this.isISPU = isISPU;
    }

    public Order isAccessPointOrder(Boolean isAccessPointOrder) {
        this.isAccessPointOrder = isAccessPointOrder;
        return this;
    }

    @ApiModelProperty(value="When true, this order is marked to be delivered to an Access Point. The access location is chosen by the customer. Access Points include Amazon Hub Lockers, Amazon Hub Counters, and pickup points operated by carriers.")
    public Boolean isIsAccessPointOrder() {
        return this.isAccessPointOrder;
    }

    public void setIsAccessPointOrder(Boolean isAccessPointOrder) {
        this.isAccessPointOrder = isAccessPointOrder;
    }

    public Order marketplaceTaxInfo(MarketplaceTaxInfo marketplaceTaxInfo) {
        this.marketplaceTaxInfo = marketplaceTaxInfo;
        return this;
    }

    @ApiModelProperty(value="Tax information about the marketplace.")
    public MarketplaceTaxInfo getMarketplaceTaxInfo() {
        return this.marketplaceTaxInfo;
    }

    public void setMarketplaceTaxInfo(MarketplaceTaxInfo marketplaceTaxInfo) {
        this.marketplaceTaxInfo = marketplaceTaxInfo;
    }

    public Order sellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
        return this;
    }

    @ApiModelProperty(value="The seller\u2019s friendly name registered in the marketplace.")
    public String getSellerDisplayName() {
        return this.sellerDisplayName;
    }

    public void setSellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
    }

    public Order shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Order buyerInfo(BuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public BuyerInfo getBuyerInfo() {
        return this.buyerInfo;
    }

    public void setBuyerInfo(BuyerInfo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public Order automatedShippingSettings(AutomatedShippingSettings automatedShippingSettings) {
        this.automatedShippingSettings = automatedShippingSettings;
        return this;
    }

    @ApiModelProperty(value="Contains information regarding the Shipping Settings Automaton program, such as whether the order's shipping settings were generated automatically, and what those settings are.")
    public AutomatedShippingSettings getAutomatedShippingSettings() {
        return this.automatedShippingSettings;
    }

    public void setAutomatedShippingSettings(AutomatedShippingSettings automatedShippingSettings) {
        this.automatedShippingSettings = automatedShippingSettings;
    }

    public Order hasRegulatedItems(Boolean hasRegulatedItems) {
        this.hasRegulatedItems = hasRegulatedItems;
        return this;
    }

    @ApiModelProperty(value="Whether the order contains regulated items which may require additional approval steps before being fulfilled.")
    public Boolean isHasRegulatedItems() {
        return this.hasRegulatedItems;
    }

    public void setHasRegulatedItems(Boolean hasRegulatedItems) {
        this.hasRegulatedItems = hasRegulatedItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.amazonOrderId, order.amazonOrderId) && Objects.equals(this.sellerOrderId, order.sellerOrderId) && Objects.equals(this.purchaseDate, order.purchaseDate) && Objects.equals(this.lastUpdateDate, order.lastUpdateDate) && Objects.equals((Object)this.orderStatus, (Object)order.orderStatus) && Objects.equals((Object)this.fulfillmentChannel, (Object)order.fulfillmentChannel) && Objects.equals(this.salesChannel, order.salesChannel) && Objects.equals(this.orderChannel, order.orderChannel) && Objects.equals(this.shipServiceLevel, order.shipServiceLevel) && Objects.equals(this.orderTotal, order.orderTotal) && Objects.equals(this.numberOfItemsShipped, order.numberOfItemsShipped) && Objects.equals(this.numberOfItemsUnshipped, order.numberOfItemsUnshipped) && Objects.equals(this.paymentExecutionDetail, order.paymentExecutionDetail) && Objects.equals((Object)this.paymentMethod, (Object)order.paymentMethod) && Objects.equals(this.paymentMethodDetails, order.paymentMethodDetails) && Objects.equals(this.marketplaceId, order.marketplaceId) && Objects.equals(this.shipmentServiceLevelCategory, order.shipmentServiceLevelCategory) && Objects.equals(this.easyShipShipmentStatus, order.easyShipShipmentStatus) && Objects.equals(this.cbaDisplayableShippingLabel, order.cbaDisplayableShippingLabel) && Objects.equals((Object)this.orderType, (Object)order.orderType) && Objects.equals(this.earliestShipDate, order.earliestShipDate) && Objects.equals(this.latestShipDate, order.latestShipDate) && Objects.equals(this.earliestDeliveryDate, order.earliestDeliveryDate) && Objects.equals(this.latestDeliveryDate, order.latestDeliveryDate) && Objects.equals(this.isBusinessOrder, order.isBusinessOrder) && Objects.equals(this.isPrime, order.isPrime) && Objects.equals(this.isPremiumOrder, order.isPremiumOrder) && Objects.equals(this.isGlobalExpressEnabled, order.isGlobalExpressEnabled) && Objects.equals(this.replacedOrderId, order.replacedOrderId) && Objects.equals(this.isReplacementOrder, order.isReplacementOrder) && Objects.equals(this.promiseResponseDueDate, order.promiseResponseDueDate) && Objects.equals(this.isEstimatedShipDateSet, order.isEstimatedShipDateSet) && Objects.equals(this.isSoldByAB, order.isSoldByAB) && Objects.equals(this.isIBA, order.isIBA) && Objects.equals(this.defaultShipFromLocationAddress, order.defaultShipFromLocationAddress) && Objects.equals((Object)this.buyerInvoicePreference, (Object)order.buyerInvoicePreference) && Objects.equals(this.buyerTaxInformation, order.buyerTaxInformation) && Objects.equals(this.fulfillmentInstruction, order.fulfillmentInstruction) && Objects.equals(this.isISPU, order.isISPU) && Objects.equals(this.isAccessPointOrder, order.isAccessPointOrder) && Objects.equals(this.marketplaceTaxInfo, order.marketplaceTaxInfo) && Objects.equals(this.sellerDisplayName, order.sellerDisplayName) && Objects.equals(this.shippingAddress, order.shippingAddress) && Objects.equals(this.buyerInfo, order.buyerInfo) && Objects.equals(this.automatedShippingSettings, order.automatedShippingSettings) && Objects.equals(this.hasRegulatedItems, order.hasRegulatedItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amazonOrderId, this.sellerOrderId, this.purchaseDate, this.lastUpdateDate, this.orderStatus, this.fulfillmentChannel, this.salesChannel, this.orderChannel, this.shipServiceLevel, this.orderTotal, this.numberOfItemsShipped, this.numberOfItemsUnshipped, this.paymentExecutionDetail, this.paymentMethod, this.paymentMethodDetails, this.marketplaceId, this.shipmentServiceLevelCategory, this.easyShipShipmentStatus, this.cbaDisplayableShippingLabel, this.orderType, this.earliestShipDate, this.latestShipDate, this.earliestDeliveryDate, this.latestDeliveryDate, this.isBusinessOrder, this.isPrime, this.isPremiumOrder, this.isGlobalExpressEnabled, this.replacedOrderId, this.isReplacementOrder, this.promiseResponseDueDate, this.isEstimatedShipDateSet, this.isSoldByAB, this.isIBA, this.defaultShipFromLocationAddress, this.buyerInvoicePreference, this.buyerTaxInformation, this.fulfillmentInstruction, this.isISPU, this.isAccessPointOrder, this.marketplaceTaxInfo, this.sellerDisplayName, this.shippingAddress, this.buyerInfo, this.automatedShippingSettings, this.hasRegulatedItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    purchaseDate: ").append(this.toIndentedString(this.purchaseDate)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    orderStatus: ").append(this.toIndentedString((Object)this.orderStatus)).append("\n");
        sb.append("    fulfillmentChannel: ").append(this.toIndentedString((Object)this.fulfillmentChannel)).append("\n");
        sb.append("    salesChannel: ").append(this.toIndentedString(this.salesChannel)).append("\n");
        sb.append("    orderChannel: ").append(this.toIndentedString(this.orderChannel)).append("\n");
        sb.append("    shipServiceLevel: ").append(this.toIndentedString(this.shipServiceLevel)).append("\n");
        sb.append("    orderTotal: ").append(this.toIndentedString(this.orderTotal)).append("\n");
        sb.append("    numberOfItemsShipped: ").append(this.toIndentedString(this.numberOfItemsShipped)).append("\n");
        sb.append("    numberOfItemsUnshipped: ").append(this.toIndentedString(this.numberOfItemsUnshipped)).append("\n");
        sb.append("    paymentExecutionDetail: ").append(this.toIndentedString(this.paymentExecutionDetail)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    paymentMethodDetails: ").append(this.toIndentedString(this.paymentMethodDetails)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    shipmentServiceLevelCategory: ").append(this.toIndentedString(this.shipmentServiceLevelCategory)).append("\n");
        sb.append("    easyShipShipmentStatus: ").append(this.toIndentedString(this.easyShipShipmentStatus)).append("\n");
        sb.append("    cbaDisplayableShippingLabel: ").append(this.toIndentedString(this.cbaDisplayableShippingLabel)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString((Object)this.orderType)).append("\n");
        sb.append("    earliestShipDate: ").append(this.toIndentedString(this.earliestShipDate)).append("\n");
        sb.append("    latestShipDate: ").append(this.toIndentedString(this.latestShipDate)).append("\n");
        sb.append("    earliestDeliveryDate: ").append(this.toIndentedString(this.earliestDeliveryDate)).append("\n");
        sb.append("    latestDeliveryDate: ").append(this.toIndentedString(this.latestDeliveryDate)).append("\n");
        sb.append("    isBusinessOrder: ").append(this.toIndentedString(this.isBusinessOrder)).append("\n");
        sb.append("    isPrime: ").append(this.toIndentedString(this.isPrime)).append("\n");
        sb.append("    isPremiumOrder: ").append(this.toIndentedString(this.isPremiumOrder)).append("\n");
        sb.append("    isGlobalExpressEnabled: ").append(this.toIndentedString(this.isGlobalExpressEnabled)).append("\n");
        sb.append("    replacedOrderId: ").append(this.toIndentedString(this.replacedOrderId)).append("\n");
        sb.append("    isReplacementOrder: ").append(this.toIndentedString(this.isReplacementOrder)).append("\n");
        sb.append("    promiseResponseDueDate: ").append(this.toIndentedString(this.promiseResponseDueDate)).append("\n");
        sb.append("    isEstimatedShipDateSet: ").append(this.toIndentedString(this.isEstimatedShipDateSet)).append("\n");
        sb.append("    isSoldByAB: ").append(this.toIndentedString(this.isSoldByAB)).append("\n");
        sb.append("    isIBA: ").append(this.toIndentedString(this.isIBA)).append("\n");
        sb.append("    defaultShipFromLocationAddress: ").append(this.toIndentedString(this.defaultShipFromLocationAddress)).append("\n");
        sb.append("    buyerInvoicePreference: ").append(this.toIndentedString((Object)this.buyerInvoicePreference)).append("\n");
        sb.append("    buyerTaxInformation: ").append(this.toIndentedString(this.buyerTaxInformation)).append("\n");
        sb.append("    fulfillmentInstruction: ").append(this.toIndentedString(this.fulfillmentInstruction)).append("\n");
        sb.append("    isISPU: ").append(this.toIndentedString(this.isISPU)).append("\n");
        sb.append("    isAccessPointOrder: ").append(this.toIndentedString(this.isAccessPointOrder)).append("\n");
        sb.append("    marketplaceTaxInfo: ").append(this.toIndentedString(this.marketplaceTaxInfo)).append("\n");
        sb.append("    sellerDisplayName: ").append(this.toIndentedString(this.sellerDisplayName)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    buyerInfo: ").append(this.toIndentedString(this.buyerInfo)).append("\n");
        sb.append("    automatedShippingSettings: ").append(this.toIndentedString(this.automatedShippingSettings)).append("\n");
        sb.append("    hasRegulatedItems: ").append(this.toIndentedString(this.hasRegulatedItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BuyerInvoicePreferenceEnum {
        INDIVIDUAL("INDIVIDUAL"),
        BUSINESS("BUSINESS");

        private String value;

        private BuyerInvoicePreferenceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BuyerInvoicePreferenceEnum fromValue(String text) {
            for (BuyerInvoicePreferenceEnum b : BuyerInvoicePreferenceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BuyerInvoicePreferenceEnum> {
            public void write(JsonWriter jsonWriter, BuyerInvoicePreferenceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BuyerInvoicePreferenceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BuyerInvoicePreferenceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrderTypeEnum {
        STANDARDORDER("StandardOrder"),
        LONGLEADTIMEORDER("LongLeadTimeOrder"),
        PREORDER("Preorder"),
        BACKORDER("BackOrder"),
        SOURCINGONDEMANDORDER("SourcingOnDemandOrder");

        private String value;

        private OrderTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrderTypeEnum fromValue(String text) {
            for (OrderTypeEnum b : OrderTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrderTypeEnum> {
            public void write(JsonWriter jsonWriter, OrderTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrderTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrderTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentMethodEnum {
        COD("COD"),
        CVS("CVS"),
        OTHER("Other");

        private String value;

        private PaymentMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentMethodEnum fromValue(String text) {
            for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PaymentMethodEnum> {
            public void write(JsonWriter jsonWriter, PaymentMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaymentMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FulfillmentChannelEnum {
        MFN("MFN"),
        AFN("AFN");

        private String value;

        private FulfillmentChannelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FulfillmentChannelEnum fromValue(String text) {
            for (FulfillmentChannelEnum b : FulfillmentChannelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FulfillmentChannelEnum> {
            public void write(JsonWriter jsonWriter, FulfillmentChannelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FulfillmentChannelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FulfillmentChannelEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrderStatusEnum {
        PENDING("Pending"),
        UNSHIPPED("Unshipped"),
        PARTIALLYSHIPPED("PartiallyShipped"),
        SHIPPED("Shipped"),
        CANCELED("Canceled"),
        UNFULFILLABLE("Unfulfillable"),
        INVOICEUNCONFIRMED("InvoiceUnconfirmed"),
        PENDINGAVAILABILITY("PendingAvailability");

        private String value;

        private OrderStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrderStatusEnum fromValue(String text) {
            for (OrderStatusEnum b : OrderStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrderStatusEnum> {
            public void write(JsonWriter jsonWriter, OrderStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrderStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrderStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

