/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.notifications;

import com.amazon.spapi.model.notifications.EventBridgeResourceSpecification;
import com.amazon.spapi.model.notifications.SqsResource;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The information required to create a destination resource. Applications should use one resource type (sqs or eventBridge) per destination.")
public class DestinationResourceSpecification {
    @SerializedName(value="sqs")
    private SqsResource sqs = null;
    @SerializedName(value="eventBridge")
    private EventBridgeResourceSpecification eventBridge = null;

    public DestinationResourceSpecification sqs(SqsResource sqs) {
        this.sqs = sqs;
        return this;
    }

    @ApiModelProperty(value="The information required to create an Amazon Simple Queue Service (SQS) queue destination.")
    public SqsResource getSqs() {
        return this.sqs;
    }

    public void setSqs(SqsResource sqs) {
        this.sqs = sqs;
    }

    public DestinationResourceSpecification eventBridge(EventBridgeResourceSpecification eventBridge) {
        this.eventBridge = eventBridge;
        return this;
    }

    @ApiModelProperty(value="The information required to create an Amazon EventBridge destination.")
    public EventBridgeResourceSpecification getEventBridge() {
        return this.eventBridge;
    }

    public void setEventBridge(EventBridgeResourceSpecification eventBridge) {
        this.eventBridge = eventBridge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationResourceSpecification destinationResourceSpecification = (DestinationResourceSpecification)o;
        return Objects.equals(this.sqs, destinationResourceSpecification.sqs) && Objects.equals(this.eventBridge, destinationResourceSpecification.eventBridge);
    }

    public int hashCode() {
        return Objects.hash(this.sqs, this.eventBridge);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DestinationResourceSpecification {\n");
        sb.append("    sqs: ").append(this.toIndentedString(this.sqs)).append("\n");
        sb.append("    eventBridge: ").append(this.toIndentedString(this.eventBridge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

