/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.notifications;

import com.amazon.spapi.model.notifications.DestinationResourceSpecification;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The request schema for the createDestination operation.")
public class CreateDestinationRequest {
    @SerializedName(value="resourceSpecification")
    private DestinationResourceSpecification resourceSpecification = null;
    @SerializedName(value="name")
    private String name = null;

    public CreateDestinationRequest resourceSpecification(DestinationResourceSpecification resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @ApiModelProperty(required=true, value="The information required to create a destination resource. Applications should use one resource type (sqs or eventBridge) per destination.")
    public DestinationResourceSpecification getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(DestinationResourceSpecification resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public CreateDestinationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="A developer-defined name to help identify this destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDestinationRequest createDestinationRequest = (CreateDestinationRequest)o;
        return Objects.equals(this.resourceSpecification, createDestinationRequest.resourceSpecification) && Objects.equals(this.name, createDestinationRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.resourceSpecification, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDestinationRequest {\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

