/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.messaging;

import com.amazon.spapi.model.messaging.Attachment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The request schema for the createWarranty operation.")
public class CreateWarrantyRequest {
    @SerializedName(value="attachments")
    private List<Attachment> attachments = null;
    @SerializedName(value="coverageStartDate")
    private OffsetDateTime coverageStartDate = null;
    @SerializedName(value="coverageEndDate")
    private OffsetDateTime coverageEndDate = null;

    public CreateWarrantyRequest attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public CreateWarrantyRequest addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Attachments to include in the message to the buyer.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public CreateWarrantyRequest coverageStartDate(OffsetDateTime coverageStartDate) {
        this.coverageStartDate = coverageStartDate;
        return this;
    }

    @ApiModelProperty(value="The start date of the warranty coverage to include in the message to the buyer.")
    public OffsetDateTime getCoverageStartDate() {
        return this.coverageStartDate;
    }

    public void setCoverageStartDate(OffsetDateTime coverageStartDate) {
        this.coverageStartDate = coverageStartDate;
    }

    public CreateWarrantyRequest coverageEndDate(OffsetDateTime coverageEndDate) {
        this.coverageEndDate = coverageEndDate;
        return this;
    }

    @ApiModelProperty(value="The end date of the warranty coverage to include in the message to the buyer.")
    public OffsetDateTime getCoverageEndDate() {
        return this.coverageEndDate;
    }

    public void setCoverageEndDate(OffsetDateTime coverageEndDate) {
        this.coverageEndDate = coverageEndDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWarrantyRequest createWarrantyRequest = (CreateWarrantyRequest)o;
        return Objects.equals(this.attachments, createWarrantyRequest.attachments) && Objects.equals(this.coverageStartDate, createWarrantyRequest.coverageStartDate) && Objects.equals(this.coverageEndDate, createWarrantyRequest.coverageEndDate);
    }

    public int hashCode() {
        return Objects.hash(this.attachments, this.coverageStartDate, this.coverageEndDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWarrantyRequest {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    coverageStartDate: ").append(this.toIndentedString(this.coverageStartDate)).append("\n");
        sb.append("    coverageEndDate: ").append(this.toIndentedString(this.coverageEndDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

