/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.messaging;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a file uploaded to a destination that was created by the createUploadDestination operation of the Uploads API.")
public class Attachment {
    @SerializedName(value="uploadDestinationId")
    private String uploadDestinationId = null;
    @SerializedName(value="fileName")
    private String fileName = null;

    public Attachment uploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the upload destination. Get this value by calling the createUploadDestination operation of the Uploads API.")
    public String getUploadDestinationId() {
        return this.uploadDestinationId;
    }

    public void setUploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
    }

    public Attachment fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the file, including the extension. This is the file name that will appear in the message. This does not need to match the file name of the file that you uploaded.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.uploadDestinationId, attachment.uploadDestinationId) && Objects.equals(this.fileName, attachment.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.uploadDestinationId, this.fileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    uploadDestinationId: ").append(this.toIndentedString(this.uploadDestinationId)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

