/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.merchantfulfillment;

import com.amazon.spapi.model.merchantfulfillment.CarrierWillPickUpOption;
import com.amazon.spapi.model.merchantfulfillment.CurrencyAmount;
import com.amazon.spapi.model.merchantfulfillment.DeliveryExperienceType;
import com.amazon.spapi.model.merchantfulfillment.LabelFormat;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Extra services provided by a carrier.")
public class ShippingServiceOptions {
    @SerializedName(value="DeliveryExperience")
    private DeliveryExperienceType deliveryExperience = null;
    @SerializedName(value="DeclaredValue")
    private CurrencyAmount declaredValue = null;
    @SerializedName(value="CarrierWillPickUp")
    private Boolean carrierWillPickUp = null;
    @SerializedName(value="CarrierWillPickUpOption")
    private CarrierWillPickUpOption carrierWillPickUpOption = null;
    @SerializedName(value="LabelFormat")
    private LabelFormat labelFormat = null;

    public ShippingServiceOptions deliveryExperience(DeliveryExperienceType deliveryExperience) {
        this.deliveryExperience = deliveryExperience;
        return this;
    }

    @ApiModelProperty(required=true, value="The delivery confirmation level.")
    public DeliveryExperienceType getDeliveryExperience() {
        return this.deliveryExperience;
    }

    public void setDeliveryExperience(DeliveryExperienceType deliveryExperience) {
        this.deliveryExperience = deliveryExperience;
    }

    public ShippingServiceOptions declaredValue(CurrencyAmount declaredValue) {
        this.declaredValue = declaredValue;
        return this;
    }

    @ApiModelProperty(value="The declared value of the shipment. The carrier uses this value to determine the amount to use to insure the shipment. If DeclaredValue is greater than the carrier's minimum insurance amount, the seller is charged for the additional insurance as determined by the carrier. For information about optional insurance coverage, see the Seller Central Help [UK](https://sellercentral.amazon.co.uk/gp/help/200204080) [US](https://sellercentral.amazon.com/gp/help/200204080).")
    public CurrencyAmount getDeclaredValue() {
        return this.declaredValue;
    }

    public void setDeclaredValue(CurrencyAmount declaredValue) {
        this.declaredValue = declaredValue;
    }

    public ShippingServiceOptions carrierWillPickUp(Boolean carrierWillPickUp) {
        this.carrierWillPickUp = carrierWillPickUp;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, the carrier will pick up the package.  Note: Scheduled carrier pickup is available only using Dynamex (US), DPD (UK), and Royal Mail (UK).")
    public Boolean isCarrierWillPickUp() {
        return this.carrierWillPickUp;
    }

    public void setCarrierWillPickUp(Boolean carrierWillPickUp) {
        this.carrierWillPickUp = carrierWillPickUp;
    }

    public ShippingServiceOptions carrierWillPickUpOption(CarrierWillPickUpOption carrierWillPickUpOption) {
        this.carrierWillPickUpOption = carrierWillPickUpOption;
        return this;
    }

    @ApiModelProperty(value="")
    public CarrierWillPickUpOption getCarrierWillPickUpOption() {
        return this.carrierWillPickUpOption;
    }

    public void setCarrierWillPickUpOption(CarrierWillPickUpOption carrierWillPickUpOption) {
        this.carrierWillPickUpOption = carrierWillPickUpOption;
    }

    public ShippingServiceOptions labelFormat(LabelFormat labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    @ApiModelProperty(value="The seller's preferred label format.")
    public LabelFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(LabelFormat labelFormat) {
        this.labelFormat = labelFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingServiceOptions shippingServiceOptions = (ShippingServiceOptions)o;
        return Objects.equals((Object)this.deliveryExperience, (Object)shippingServiceOptions.deliveryExperience) && Objects.equals(this.declaredValue, shippingServiceOptions.declaredValue) && Objects.equals(this.carrierWillPickUp, shippingServiceOptions.carrierWillPickUp) && Objects.equals((Object)this.carrierWillPickUpOption, (Object)shippingServiceOptions.carrierWillPickUpOption) && Objects.equals((Object)this.labelFormat, (Object)shippingServiceOptions.labelFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deliveryExperience, this.declaredValue, this.carrierWillPickUp, this.carrierWillPickUpOption, this.labelFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingServiceOptions {\n");
        sb.append("    deliveryExperience: ").append(this.toIndentedString((Object)this.deliveryExperience)).append("\n");
        sb.append("    declaredValue: ").append(this.toIndentedString(this.declaredValue)).append("\n");
        sb.append("    carrierWillPickUp: ").append(this.toIndentedString(this.carrierWillPickUp)).append("\n");
        sb.append("    carrierWillPickUpOption: ").append(this.toIndentedString((Object)this.carrierWillPickUpOption)).append("\n");
        sb.append("    labelFormat: ").append(this.toIndentedString((Object)this.labelFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

