/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.merchantfulfillment;

import com.amazon.spapi.model.merchantfulfillment.AvailableFormatOptionsForLabelList;
import com.amazon.spapi.model.merchantfulfillment.AvailableShippingServiceOptions;
import com.amazon.spapi.model.merchantfulfillment.CurrencyAmount;
import com.amazon.spapi.model.merchantfulfillment.LabelFormatList;
import com.amazon.spapi.model.merchantfulfillment.ShippingServiceOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A shipping service offer made by a carrier.")
public class ShippingService {
    @SerializedName(value="ShippingServiceName")
    private String shippingServiceName = null;
    @SerializedName(value="CarrierName")
    private String carrierName = null;
    @SerializedName(value="ShippingServiceId")
    private String shippingServiceId = null;
    @SerializedName(value="ShippingServiceOfferId")
    private String shippingServiceOfferId = null;
    @SerializedName(value="ShipDate")
    private String shipDate = null;
    @SerializedName(value="EarliestEstimatedDeliveryDate")
    private String earliestEstimatedDeliveryDate = null;
    @SerializedName(value="LatestEstimatedDeliveryDate")
    private String latestEstimatedDeliveryDate = null;
    @SerializedName(value="Rate")
    private CurrencyAmount rate = null;
    @SerializedName(value="ShippingServiceOptions")
    private ShippingServiceOptions shippingServiceOptions = null;
    @SerializedName(value="AvailableShippingServiceOptions")
    private AvailableShippingServiceOptions availableShippingServiceOptions = null;
    @SerializedName(value="AvailableLabelFormats")
    private LabelFormatList availableLabelFormats = null;
    @SerializedName(value="AvailableFormatOptionsForLabel")
    private AvailableFormatOptionsForLabelList availableFormatOptionsForLabel = null;
    @SerializedName(value="RequiresAdditionalSellerInputs")
    private Boolean requiresAdditionalSellerInputs = null;

    public ShippingService shippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
        return this;
    }

    @ApiModelProperty(required=true, value="A plain text representation of a carrier's shipping service. For example, \"UPS Ground\" or \"FedEx Standard Overnight\". ")
    public String getShippingServiceName() {
        return this.shippingServiceName;
    }

    public void setShippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
    }

    public ShippingService carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the carrier.")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public ShippingService shippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getShippingServiceId() {
        return this.shippingServiceId;
    }

    public void setShippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
    }

    public ShippingService shippingServiceOfferId(String shippingServiceOfferId) {
        this.shippingServiceOfferId = shippingServiceOfferId;
        return this;
    }

    @ApiModelProperty(required=true, value="An Amazon-defined shipping service offer identifier.")
    public String getShippingServiceOfferId() {
        return this.shippingServiceOfferId;
    }

    public void setShippingServiceOfferId(String shippingServiceOfferId) {
        this.shippingServiceOfferId = shippingServiceOfferId;
    }

    public ShippingService shipDate(String shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date that the carrier will ship the package.")
    public String getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(String shipDate) {
        this.shipDate = shipDate;
    }

    public ShippingService earliestEstimatedDeliveryDate(String earliestEstimatedDeliveryDate) {
        this.earliestEstimatedDeliveryDate = earliestEstimatedDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="The earliest date by which the shipment will be delivered.")
    public String getEarliestEstimatedDeliveryDate() {
        return this.earliestEstimatedDeliveryDate;
    }

    public void setEarliestEstimatedDeliveryDate(String earliestEstimatedDeliveryDate) {
        this.earliestEstimatedDeliveryDate = earliestEstimatedDeliveryDate;
    }

    public ShippingService latestEstimatedDeliveryDate(String latestEstimatedDeliveryDate) {
        this.latestEstimatedDeliveryDate = latestEstimatedDeliveryDate;
        return this;
    }

    @ApiModelProperty(value="The latest date by which the shipment will be delivered.")
    public String getLatestEstimatedDeliveryDate() {
        return this.latestEstimatedDeliveryDate;
    }

    public void setLatestEstimatedDeliveryDate(String latestEstimatedDeliveryDate) {
        this.latestEstimatedDeliveryDate = latestEstimatedDeliveryDate;
    }

    public ShippingService rate(CurrencyAmount rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount that the carrier will charge for the shipment.")
    public CurrencyAmount getRate() {
        return this.rate;
    }

    public void setRate(CurrencyAmount rate) {
        this.rate = rate;
    }

    public ShippingService shippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
        return this;
    }

    @ApiModelProperty(required=true, value="Extra services offered by the carrier.")
    public ShippingServiceOptions getShippingServiceOptions() {
        return this.shippingServiceOptions;
    }

    public void setShippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
    }

    public ShippingService availableShippingServiceOptions(AvailableShippingServiceOptions availableShippingServiceOptions) {
        this.availableShippingServiceOptions = availableShippingServiceOptions;
        return this;
    }

    @ApiModelProperty(value="")
    public AvailableShippingServiceOptions getAvailableShippingServiceOptions() {
        return this.availableShippingServiceOptions;
    }

    public void setAvailableShippingServiceOptions(AvailableShippingServiceOptions availableShippingServiceOptions) {
        this.availableShippingServiceOptions = availableShippingServiceOptions;
    }

    public ShippingService availableLabelFormats(LabelFormatList availableLabelFormats) {
        this.availableLabelFormats = availableLabelFormats;
        return this;
    }

    @ApiModelProperty(value="")
    public LabelFormatList getAvailableLabelFormats() {
        return this.availableLabelFormats;
    }

    public void setAvailableLabelFormats(LabelFormatList availableLabelFormats) {
        this.availableLabelFormats = availableLabelFormats;
    }

    public ShippingService availableFormatOptionsForLabel(AvailableFormatOptionsForLabelList availableFormatOptionsForLabel) {
        this.availableFormatOptionsForLabel = availableFormatOptionsForLabel;
        return this;
    }

    @ApiModelProperty(value="")
    public AvailableFormatOptionsForLabelList getAvailableFormatOptionsForLabel() {
        return this.availableFormatOptionsForLabel;
    }

    public void setAvailableFormatOptionsForLabel(AvailableFormatOptionsForLabelList availableFormatOptionsForLabel) {
        this.availableFormatOptionsForLabel = availableFormatOptionsForLabel;
    }

    public ShippingService requiresAdditionalSellerInputs(Boolean requiresAdditionalSellerInputs) {
        this.requiresAdditionalSellerInputs = requiresAdditionalSellerInputs;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, additional seller inputs are required.")
    public Boolean isRequiresAdditionalSellerInputs() {
        return this.requiresAdditionalSellerInputs;
    }

    public void setRequiresAdditionalSellerInputs(Boolean requiresAdditionalSellerInputs) {
        this.requiresAdditionalSellerInputs = requiresAdditionalSellerInputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingService shippingService = (ShippingService)o;
        return Objects.equals(this.shippingServiceName, shippingService.shippingServiceName) && Objects.equals(this.carrierName, shippingService.carrierName) && Objects.equals(this.shippingServiceId, shippingService.shippingServiceId) && Objects.equals(this.shippingServiceOfferId, shippingService.shippingServiceOfferId) && Objects.equals(this.shipDate, shippingService.shipDate) && Objects.equals(this.earliestEstimatedDeliveryDate, shippingService.earliestEstimatedDeliveryDate) && Objects.equals(this.latestEstimatedDeliveryDate, shippingService.latestEstimatedDeliveryDate) && Objects.equals(this.rate, shippingService.rate) && Objects.equals(this.shippingServiceOptions, shippingService.shippingServiceOptions) && Objects.equals(this.availableShippingServiceOptions, shippingService.availableShippingServiceOptions) && Objects.equals(this.availableLabelFormats, shippingService.availableLabelFormats) && Objects.equals(this.availableFormatOptionsForLabel, shippingService.availableFormatOptionsForLabel) && Objects.equals(this.requiresAdditionalSellerInputs, shippingService.requiresAdditionalSellerInputs);
    }

    public int hashCode() {
        return Objects.hash(this.shippingServiceName, this.carrierName, this.shippingServiceId, this.shippingServiceOfferId, this.shipDate, this.earliestEstimatedDeliveryDate, this.latestEstimatedDeliveryDate, this.rate, this.shippingServiceOptions, this.availableShippingServiceOptions, this.availableLabelFormats, this.availableFormatOptionsForLabel, this.requiresAdditionalSellerInputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingService {\n");
        sb.append("    shippingServiceName: ").append(this.toIndentedString(this.shippingServiceName)).append("\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    shippingServiceId: ").append(this.toIndentedString(this.shippingServiceId)).append("\n");
        sb.append("    shippingServiceOfferId: ").append(this.toIndentedString(this.shippingServiceOfferId)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    earliestEstimatedDeliveryDate: ").append(this.toIndentedString(this.earliestEstimatedDeliveryDate)).append("\n");
        sb.append("    latestEstimatedDeliveryDate: ").append(this.toIndentedString(this.latestEstimatedDeliveryDate)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    shippingServiceOptions: ").append(this.toIndentedString(this.shippingServiceOptions)).append("\n");
        sb.append("    availableShippingServiceOptions: ").append(this.toIndentedString(this.availableShippingServiceOptions)).append("\n");
        sb.append("    availableLabelFormats: ").append(this.toIndentedString(this.availableLabelFormats)).append("\n");
        sb.append("    availableFormatOptionsForLabel: ").append(this.toIndentedString(this.availableFormatOptionsForLabel)).append("\n");
        sb.append("    requiresAdditionalSellerInputs: ").append(this.toIndentedString(this.requiresAdditionalSellerInputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

