/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.merchantfulfillment;

import com.amazon.spapi.model.merchantfulfillment.Address;
import com.amazon.spapi.model.merchantfulfillment.ItemList;
import com.amazon.spapi.model.merchantfulfillment.LabelCustomization;
import com.amazon.spapi.model.merchantfulfillment.PackageDimensions;
import com.amazon.spapi.model.merchantfulfillment.ShippingServiceOptions;
import com.amazon.spapi.model.merchantfulfillment.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Shipment information required for requesting shipping service offers or for creating a shipment.")
public class ShipmentRequestDetails {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="ItemList")
    private ItemList itemList = null;
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="PackageDimensions")
    private PackageDimensions packageDimensions = null;
    @SerializedName(value="Weight")
    private Weight weight = null;
    @SerializedName(value="MustArriveByDate")
    private String mustArriveByDate = null;
    @SerializedName(value="ShipDate")
    private String shipDate = null;
    @SerializedName(value="ShippingServiceOptions")
    private ShippingServiceOptions shippingServiceOptions = null;
    @SerializedName(value="LabelCustomization")
    private LabelCustomization labelCustomization = null;

    public ShipmentRequestDetails amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="An Amazon-defined order identifier in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ShipmentRequestDetails sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @ApiModelProperty(value="A seller-defined order identifier.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public ShipmentRequestDetails itemList(ItemList itemList) {
        this.itemList = itemList;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ItemList getItemList() {
        return this.itemList;
    }

    public void setItemList(ItemList itemList) {
        this.itemList = itemList;
    }

    public ShipmentRequestDetails shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The address of the sender.")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public ShipmentRequestDetails packageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
        return this;
    }

    @ApiModelProperty(required=true, value="The package dimensions.")
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public ShipmentRequestDetails weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(required=true, value="The package weight.")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public ShipmentRequestDetails mustArriveByDate(String mustArriveByDate) {
        this.mustArriveByDate = mustArriveByDate;
        return this;
    }

    @ApiModelProperty(value="The date by which the package must arrive to keep the promise to the customer, in ISO 8601 datetime format. If MustArriveByDate is specified, only shipping service offers that can be delivered by that date are returned.")
    public String getMustArriveByDate() {
        return this.mustArriveByDate;
    }

    public void setMustArriveByDate(String mustArriveByDate) {
        this.mustArriveByDate = mustArriveByDate;
    }

    public ShipmentRequestDetails shipDate(String shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @ApiModelProperty(value="When used in a request, this is the date and time that the seller wants to ship the package. When used in a response, this is the date and time that the package can be shipped by the indicated method.")
    public String getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(String shipDate) {
        this.shipDate = shipDate;
    }

    public ShipmentRequestDetails shippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
        return this;
    }

    @ApiModelProperty(required=true, value="Extra services offered by the carrier.")
    public ShippingServiceOptions getShippingServiceOptions() {
        return this.shippingServiceOptions;
    }

    public void setShippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
    }

    public ShipmentRequestDetails labelCustomization(LabelCustomization labelCustomization) {
        this.labelCustomization = labelCustomization;
        return this;
    }

    @ApiModelProperty(value="Label customization options.")
    public LabelCustomization getLabelCustomization() {
        return this.labelCustomization;
    }

    public void setLabelCustomization(LabelCustomization labelCustomization) {
        this.labelCustomization = labelCustomization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentRequestDetails shipmentRequestDetails = (ShipmentRequestDetails)o;
        return Objects.equals(this.amazonOrderId, shipmentRequestDetails.amazonOrderId) && Objects.equals(this.sellerOrderId, shipmentRequestDetails.sellerOrderId) && Objects.equals(this.itemList, shipmentRequestDetails.itemList) && Objects.equals(this.shipFromAddress, shipmentRequestDetails.shipFromAddress) && Objects.equals(this.packageDimensions, shipmentRequestDetails.packageDimensions) && Objects.equals(this.weight, shipmentRequestDetails.weight) && Objects.equals(this.mustArriveByDate, shipmentRequestDetails.mustArriveByDate) && Objects.equals(this.shipDate, shipmentRequestDetails.shipDate) && Objects.equals(this.shippingServiceOptions, shipmentRequestDetails.shippingServiceOptions) && Objects.equals(this.labelCustomization, shipmentRequestDetails.labelCustomization);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.sellerOrderId, this.itemList, this.shipFromAddress, this.packageDimensions, this.weight, this.mustArriveByDate, this.shipDate, this.shippingServiceOptions, this.labelCustomization);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentRequestDetails {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    packageDimensions: ").append(this.toIndentedString(this.packageDimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    mustArriveByDate: ").append(this.toIndentedString(this.mustArriveByDate)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    shippingServiceOptions: ").append(this.toIndentedString(this.shippingServiceOptions)).append("\n");
        sb.append("    labelCustomization: ").append(this.toIndentedString(this.labelCustomization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

