/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.merchantfulfillment;

import com.amazon.spapi.model.merchantfulfillment.AdditionalSellerInputsList;
import com.amazon.spapi.model.merchantfulfillment.TransparencyCodeList;
import com.amazon.spapi.model.merchantfulfillment.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An Amazon order item identifier and a quantity.")
public class Item {
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="Quantity")
    private Integer quantity = null;
    @SerializedName(value="ItemWeight")
    private Weight itemWeight = null;
    @SerializedName(value="ItemDescription")
    private String itemDescription = null;
    @SerializedName(value="TransparencyCodeList")
    private TransparencyCodeList transparencyCodeList = null;
    @SerializedName(value="ItemLevelSellerInputsList")
    private AdditionalSellerInputsList itemLevelSellerInputsList = null;

    public Item orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public Item quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Item itemWeight(Weight itemWeight) {
        this.itemWeight = itemWeight;
        return this;
    }

    @ApiModelProperty(value="")
    public Weight getItemWeight() {
        return this.itemWeight;
    }

    public void setItemWeight(Weight itemWeight) {
        this.itemWeight = itemWeight;
    }

    public Item itemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
        return this;
    }

    @ApiModelProperty(value="")
    public String getItemDescription() {
        return this.itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public Item transparencyCodeList(TransparencyCodeList transparencyCodeList) {
        this.transparencyCodeList = transparencyCodeList;
        return this;
    }

    @ApiModelProperty(value="")
    public TransparencyCodeList getTransparencyCodeList() {
        return this.transparencyCodeList;
    }

    public void setTransparencyCodeList(TransparencyCodeList transparencyCodeList) {
        this.transparencyCodeList = transparencyCodeList;
    }

    public Item itemLevelSellerInputsList(AdditionalSellerInputsList itemLevelSellerInputsList) {
        this.itemLevelSellerInputsList = itemLevelSellerInputsList;
        return this;
    }

    @ApiModelProperty(value="A list of additional seller inputs required to ship this item using the chosen shipping service.")
    public AdditionalSellerInputsList getItemLevelSellerInputsList() {
        return this.itemLevelSellerInputsList;
    }

    public void setItemLevelSellerInputsList(AdditionalSellerInputsList itemLevelSellerInputsList) {
        this.itemLevelSellerInputsList = itemLevelSellerInputsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.orderItemId, item.orderItemId) && Objects.equals(this.quantity, item.quantity) && Objects.equals(this.itemWeight, item.itemWeight) && Objects.equals(this.itemDescription, item.itemDescription) && Objects.equals(this.transparencyCodeList, item.transparencyCodeList) && Objects.equals(this.itemLevelSellerInputsList, item.itemLevelSellerInputsList);
    }

    public int hashCode() {
        return Objects.hash(this.orderItemId, this.quantity, this.itemWeight, this.itemDescription, this.transparencyCodeList, this.itemLevelSellerInputsList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    itemWeight: ").append(this.toIndentedString(this.itemWeight)).append("\n");
        sb.append("    itemDescription: ").append(this.toIndentedString(this.itemDescription)).append("\n");
        sb.append("    transparencyCodeList: ").append(this.toIndentedString(this.transparencyCodeList)).append("\n");
        sb.append("    itemLevelSellerInputsList: ").append(this.toIndentedString(this.itemLevelSellerInputsList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

