/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsrestrictions;

import com.amazon.spapi.model.listingsrestrictions.Link;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A reason for the restriction, including path forward links that may allow Selling Partners to remove the restriction, if available.")
public class Reason {
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reasonCode")
    private ReasonCodeEnum reasonCode = null;
    @SerializedName(value="links")
    private List<Link> links = null;

    public Reason message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="A message describing the reason for the restriction.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Reason reasonCode(ReasonCodeEnum reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @ApiModelProperty(value="A code indicating why the listing is restricted.")
    public ReasonCodeEnum getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(ReasonCodeEnum reasonCode) {
        this.reasonCode = reasonCode;
    }

    public Reason links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Reason addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="A list of path forward links that may allow Selling Partners to remove the restriction.")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reason reason = (Reason)o;
        return Objects.equals(this.message, reason.message) && Objects.equals((Object)this.reasonCode, (Object)reason.reasonCode) && Objects.equals(this.links, reason.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.reasonCode, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reason {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString((Object)this.reasonCode)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonCodeEnum {
        APPROVAL_REQUIRED("APPROVAL_REQUIRED"),
        ASIN_NOT_FOUND("ASIN_NOT_FOUND"),
        NOT_ELIGIBLE("NOT_ELIGIBLE");

        private String value;

        private ReasonCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonCodeEnum fromValue(String text) {
            for (ReasonCodeEnum b : ReasonCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ReasonCodeEnum> {
            public void write(JsonWriter jsonWriter, ReasonCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonCodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

