/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsitems;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Individual JSON Patch operation for an HTTP PATCH request.")
public class PatchOperation {
    @SerializedName(value="op")
    private OpEnum op = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="value")
    private List<Object> value = null;

    public PatchOperation op(OpEnum op) {
        this.op = op;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of JSON Patch operation. Supported JSON Patch operations include add, replace, and delete. See <https://tools.ietf.org/html/rfc6902>.")
    public OpEnum getOp() {
        return this.op;
    }

    public void setOp(OpEnum op) {
        this.op = op;
    }

    public PatchOperation path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="JSON Pointer path of the element to patch. See <https://tools.ietf.org/html/rfc6902>.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PatchOperation value(List<Object> value) {
        this.value = value;
        return this;
    }

    public PatchOperation addValueItem(Object valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<Object>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="JSON value to add, replace, or delete.")
    public List<Object> getValue() {
        return this.value;
    }

    public void setValue(List<Object> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchOperation patchOperation = (PatchOperation)o;
        return Objects.equals((Object)this.op, (Object)patchOperation.op) && Objects.equals(this.path, patchOperation.path) && Objects.equals(this.value, patchOperation.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.path, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchOperation {\n");
        sb.append("    op: ").append(this.toIndentedString((Object)this.op)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OpEnum {
        ADD("add"),
        REPLACE("replace"),
        DELETE("delete");

        private String value;

        private OpEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OpEnum fromValue(String text) {
            for (OpEnum b : OpEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OpEnum> {
            public void write(JsonWriter jsonWriter, OpEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OpEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OpEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

